//Описываем структуру формы настроек в виде многоуровневого массива
const composition = [

    {
        //Вкладка "Подключения"
        header: 'apps',

        forms: [

            {

                header: "apps_header",

                //listForm=true - форма со списком, управляет массивом настроек
                listForm: true,

                //field: поле, содержащее массив настроек
                field: "apps",

                //addButton: текст ссылки добавления нового элемента
                addButton: "add_app",

                //listFields - поля, которые будут выведены в списке
                listFields: ['name'],

                //Форма добавления/редактирования может быть задана через formBlocks, formLines, fields
                //Для краткости примера создаем через fields
                fields: ['name', 'auth_bot_id', 'auth_token'],

                archive: {
                    field: "arc",
                    on: 1,
                    off: 0
                },

                activity:  {
                    field: "disabled",
                    on: 0,
                    off: 1
                },

                copy: true,

                alert: {
                    field: "auth_error"
                }

            }

        ]

    },

    {
        //Вкладка "Интеграции"
        header: 'connectors',

        forms: [

            {

                showOn: 'apps',

                header: "connectors",
                
                //listForm=true - форма со списком, управляет массивом настроек
                listForm: true,

                //field: поле, содержащее массив настроек
                field: "connectors",

                //addButton: текст ссылки добавления нового элемента
                addButton: "add_connector",

                //listFields - поля, которые будут выведены в списке
                listFields: ['name'],


                formBlocks: [
                    { //Общие настройки интеграции
                        fields: ['name', 'external_app_id', "instant" ,"internal_object_id"]
                    },

                    {
                        //Настройки вызова команда
                        header: 'connector_command_settings',       
                        fields: ['external_action'],
                        custom: {
                            'integration-fields-mapping': {
                                prefix: "external_action_params_",
                                fieldsList: "params",
                                fieldsType: true,
                                app_object: "external_object_type",
                                app_object_static: "telegram",
                                app_action: "external_action",
                                help: "help_telegram_bot",
                                help_unique: true
                            }
                        }                                        
                    },  

                    {
                        header: "fields_mapping",
                        custom: {
                            "integration-fields-mapping": {
                                app_object: "external_object_type",
                                app_object_static: "telegram",
                                app_action: "external_action",
                                table: "internal_object_id",
                                help: "help_telegram_bot",
                                help_unique: true
                            },
                        },
                    },

                   
                    {
                        showOn: "calc",
                        fields: ["calc"]
                    }


                ],

                archive: {
                    field: "arc",
                    on: "1",
                    off: "0"
                },
                
                activity:  {
                    field: "disabled",
                    on: 0,
                    off: 1
                },

                copy: true,

                alert: {
                    field: "__error"
                }

            },  

            {
                hideOn: 'apps',
                saveButton: false,

                formBlocks: [
                    {
                        message: {
                            template: "Начните настройку модуля с создания подключения",
                            status: "alert"
                        }
                    }
                ]
            }            


        ]

    },
/*
    {
        //Вкладка "Дополнительно"
        header: 'misc'
    }
*/

];

export default composition;