import useSaveSettings from '../../hooks/useSaveSettings.js';
import useAccessTabWazzupExtensionStore from './../../store/useAccessTabWazzupExtensionStore.js';


const { inject, ref, onMounted } = Vue;


/**
 * Компонент добавления пользователя
 */
export default {
  setup(props, {emit}) {
    onMounted(_ => initChosen());

    const accessStore = useAccessTabWazzupExtensionStore();
    const metaUsers   = inject('metaUsers');

    const id   = ref('');
    const name = ref('');

    // Установить плагин chosen на селекты с классом chosen_add
    function initChosen() {
      $('.chosen_add')
        .chosen()
        .change(event => {
          id.value = event.target.value;
          let username = metaUsers.filter(i => i.id == id.value);
          name.value = username[0]?.fio || "";
        });
    }

    return {
      metaUsers,
      id,   // идентификатор пользователя в кб
      name, // имя пользователя в wazzup

      /** Создать пользователя */
      addUser() {
        (new Promise((resolve, reject) => {
          resolve(accessStore.createUser({
            "id":   `clientbase_${id.value}`,
            "name": name.value
          }))
        })).then(_ => useSaveSettings(null));

        name.value = id.value = '';
      },
    }
  },

  template: /*html*/`
    <div class="wazzup__container" style="margin: 25px 0;">
      <table class="wazzup__users_list-table">
        <caption><b>{{ $t('add_user') }}</b></caption>

        <tr>
          <td style="text-align:right;"><span>{{ $t('User') }}</span></td>
          <td>
            <span h_id="wazzup_new_user_id" class="help_bt"></span>
            <span>:</span>
          </td>
          <td>
            <select
              class="form-control chosen_add"
              v-model="id"
              style="width:200px;"
            >
              <option v-for="user in metaUsers" :value="user.id">{{ user.fio }}</option>
            </select>
          </td>
        </tr>

        <tr>
          <td style="text-align:right;"><span>{{ $t('username') }}</span></td>
          <td>
            <span h_id="wazzup_new_user_name" class="help_bt"></span>
            <span>:</span>
          </td>
          <td>
            <input
              type="text"
              class="form-control"
              v-model="name"
              style="width:210px;"
            />
          </td>
        </tr>

        <tr>
          <td colspan="3" style="text-align:center; padding-top:10px;">
            <button
              class="btn btn-default"
              @click="addUser"
            >{{ $t('add_user') }}</button>
          </td>
        </tr>
      </table>
    </div>
  `
}
