import useApiTabWazzupExtensionStore from './../../store/useApiTabWazzupExtensionStore.js';

export const ApiComponent = {
  name: 'api-component',
  emits: ['saveHandle'],

  setup() {
    const apiStore = useApiTabWazzupExtensionStore();

    Vue.onMounted(() => {
      checkHelpButtonsOnCurrentPage();
      bind_help_bt('wazzup');
    });

    return {
      apiStore
    }
  },

  template: /*html*/`
    <div class="wazzup__content">
      <div>
        <span
          v-if="apiStore.is_active"
          style="color: green;font-weight: normal;"
        >{{ $t('module_activated') }}</span>
        <span
          v-else
          style="color: red;font-weight: normal;"
        >{{ $t('module_not_activated') }}</span>
      </div>

      <div class="wazzup__key_block">
        <span>{{ $t('api_key') }}</span>
        <span h_id="wazzup_api_key" class="help_bt"></span>
        <span>:</span>

        <input
          type="text"
          class="form-control"
          :value="apiStore.api_key"
          @input="apiStore.api_key = $event.target.value"
          @blur="apiStore.authRequest"
        />

        <a
          href="https://wazzup24.com/?utm_p=XBJtrY6M"
          target="__blank"
          style="margin-left: 6px;"
        >{{ $t('personal_account') }}</a>
      </div>
    </div>

    <hr style="width: 50%;">
    <save-button
      @click-handle="$emit('saveHandle')"
    ></save-button>
  `
}
