import { useEditFormStore } from "../store/storeForm.js";

export const formBaseElement = {
  props: {
    element: Object,
    dataSource: Object,
    fieldsSource: Object      
  },
  data() {
    const store = useEditFormStore();
    const actualFieldsSource = this.fieldsSource || store.fields;
    const { data } = Pinia.storeToRefs(store);
    const actualDataSource = this.dataSource || data;
    var hidden = true;

    //Для listform и форм на основе вложенного элемента
    var field = null;
    var formFieldsSource = this.fieldsSource;
    if (this.element.field) {
      field = this.element.field;
      formFieldsSource = actualFieldsSource[field];
    }
    return {
      store,
      actualFieldsSource,
      actualDataSource,
      hidden,
      field,
      formFieldsSource,
      data
    }
  },
  computed: {
    toggleLink: function() {
      return this.element['toggle'];
    },
    toggleShow: function() {
      return !this.element['toggle'] || !this.hidden;
    },
    showOn() {
      
      const { showOn, showOnValue, hideOn, hideOnValue } = this.element;
        
      const showValue = this.actualDataSource?.[showOn];
      const hideValue = this.actualDataSource?.[hideOn];
    
      let isShow = true;
      
      let isEmpty = (val) => {
        if (Array.isArray(val)) return val.length === 0;
        if (val && typeof val === 'object') return Object.keys(val).length === 0;
        return !val; // на случай других типов
      };      
      let isEqual = (value, target) => {
        if(Array.isArray(target)) 
          return target.includes(value);
        return value == target;
      };      

      if (showOn) {
        isShow = showOnValue === undefined 
          ? !isEmpty(showValue) 
          : isEqual(showValue, showOnValue);
      }
    
      if (hideOn) {
        isShow = hideOnValue === undefined 
          ? isEmpty(hideValue) 
          : !isEqual(hideValue, hideOnValue);
      }
      
      return isShow;
    } 
  },
  methods: {
    toggle(e) {
      e.preventDefault();
      this.hidden = !this.hidden;
    },
    linesFromFields() {
      if (this.element.fields) {
        this.element.formLines = this.element.formLines || [];
        for (var fieldId in this.element.fields) {
          let field = this.element.fields[fieldId];
          this.element.formLines.push({
            "label": field,
            "fields": [field]
          });
        }
        delete this.element.fields;
      }
    },
    blocksFromLines() {
      if (this.element.formLines) {
        this.element.formBlocks = this.element.formBlocks || [];
        this.element.formBlocks.push({
          "formLines": this.element.formLines
        });
        delete this.element.formLines;
      }
    },
    formsFromBlocks() {
      if (this.element.formBlocks) {
        this.element.forms = this.element.forms || [];
        this.element.forms.push({
          "formBlocks": this.element.formBlocks
        });
        delete this.element.formBlocks;
      }
    }
  },
};
