/**
 * Компонент Настройки Блока Текста
 */
import { useBlocksStore } from '../storeBlocks.js'

const template = /*html*/`
<div class="card">
  <div class="field grid">
    <label for="title" class="col-12 mb-2 md:col-2 md:mb-0">Title:</label>
    <div class="col-12 md:col-10" id="title">
      <p-inputtext v-model="new_block.title"></p-inputtext>
    </div>
  </div>
  <div class="field grid">
    <label for="content" class="col-12 mb-2 md:col-2 md:mb-0">Content:</label>
    <div class="col-12 md:col-10" id="content">
      <p-inputtext v-model="new_block.content"></p-inputtext>
    </div>
  </div>
</div>
`;

export default {
  template,
  components: {
    "p-inputtext": primevue.inputtext,
  },

  setup() {
    const { new_block } = useBlocksStore()

    return {
      new_block,
    }
  },
}

CB.styles.globed(/*css*/`
`);
