import useTranslate from "../../../../hooks/useTranslate.js";
import useKOSearchBlockStore from "./../store/index.js";


/** Компонент выбора вида поиска */
export const RadioComponent = {
  emits: ['handleChange'],

  setup(props, {emit}) {
    const store = useKOSearchBlockStore();

    return {
      store,
      items: [
        { id: 2, label: 'All_words' },
        { id: 1, label: 'Exact_phrase' },
        { id: 3, label: 'Any_of_the_words' },
      ],
      useTranslate: useTranslate,
    }
  },

  template: /*html*/`
    <div class="__KO__radio-component__container">
      <div
        v-for="item in items"
        :key="item.id"
        class="__KO__radio-component__item"
      >
        <input
          type="radio"
          :value="item.id"
          v-model="store.search_type"
          @click='store.search_string == "" ? null : $emit("handleChange")'
        />
        <span>{{ useTranslate(item.label) }}</span>
      </div>
    </div>
  `
}


// стили компонента
CB.styles.globed(/*css*/`
  .__KO__radio-component__container {
    display: flex;
    gap: 10px;
    align-items: center;
    justify-content: center;
    margin-bottom: 15px;
  }

  .__KO__radio-component__item {
    display: flex;
    gap: 5px;
    max-width: fit-content;
  }
`);
