'use strict';

import { getLang } from "../../lang.js";

export function CallNotification(_store){
    let l = getLang(config["lang"] == "russian" ? config["lang"] : "english");
    let store = _store.attrs.store;

    return {
        view: function(){
            return store.get('show_call_notification')
                ? m('div', {
                    class: 'call_notification--container',
                    style: 'display:block;'
                }, [
                    m('div', {
                        class: 'call_notification--header',
                        style: 'color: #505050'
                    }, [
                        m('div', {
                            class: 'call_notification--header-bell'
                        }),
                        m('div', {
                            class: 'call_notification--header-title'
                        }, store.get('notification_title') || 'Asterisk'),
                    ]),
                    m('button', {
                        class: 'call_notification--header-close',
                        onclick: store.get('closeNotification')
                    }),
                    store.get('is_call')
                        ? m('div', {
                            class: 'event_content event_content--asterisk event_content--fix-height',
                            style: 'color: rgb(80, 80, 80);'
                        },[
                            m('div', {}, [
                                m('span',{},lang['Time'] + ':'),
                                m('span',{},store.get('asterisk_time')),
                            ])
                        ])
                        : null,
                    store.get('call_type') == 'incoming' || store.get('call_type') == 'outgoing'
                        ? m('div', {}, [
                            m('div', {
                                style: `padding: 10px 0 0 15px; color: rgb(80, 80, 80);`,
                            }, `${store.get('call_type') == 'incoming' ? 'From' : 'To'}: ${store.get('notification_info').from_number}`),
                            m('div', {
                                style: `padding: 0 0 0 15px; color: rgb(80, 80, 80);`,
                            }, `${lang['Card']}:`),
                            m('div', {}, [
                                m('b', {
                                    style: `padding: 0 0 0 15px; color: rgb(80, 80, 80);`
                                }, store.get('notification_info').from),
                                m('a', {
                                    href: store.get('notification_info').from_url,
                                    class: 'call_window_link',
                                    target: '_blank',
                                    style: `color: #ffc250;`,
                                },
                                m('b', {}, store.get('notification_info').from_name == ''
                                    ? lang['create']
                                    : store.get('notification_info').from_name)
                                )
                            ]
                            ),
                            trim(store.get('notification_info').addit_1) != ':'
                                ? m('div', {
                                    style: `padding: 0 0 0 15px; color: rgb(80, 80, 80);`,
                                }, store.get('notification_info').addit_1)
                                : null,
                            trim(store.get('notification_info').addit_2) != ':'
                                ? m('div', {
                                    style: `padding: 0 0 0 15px; color: rgb(80, 80, 80);`,
                                }, store.get('notification_info').addit_2)
                                : null,
                            trim(store.get('notification_info').addit_3) != ':'
                                ? m('div', {
                                    style: `padding: 0 0 0 15px; color: rgb(80, 80, 80);`,
                                }, store.get('notification_info').addit_3)
                                : null,
                        ]) : null,
                    trim(store.get('notification_text')) != ''
                        ? m('div', {
                            style: `padding: 10px 0 10px 15px; color: rgb(80, 80, 80);`,
                        }, store.get('notification_text'))
                        : null,
                ])
                : null;
        }
    }
}
