'use strict';

/** Встроить скрипт js на страницу */
const addScript = (url) => new Promise((resolve, reject) => {
  let script = document.createElement("script");
  script.type = "text/javascript";
  script.onload = function(){
    resolve(1);
  };

  script.src = url;
  document.head.appendChild(script);
});


/** Создать и встроить в dom элемент */
const createElement = (type, params = {}, container, type_include) => {
  let element = document.createElement(type);

  for(let param in params){
    if(typeof params[param] == 'boolean'){
      element[param] = true;
    }  else {
      element.setAttribute(param, params[param]);
    }
  }

  if(type_include == 'prepand'){
    container.before(element);
  } else {
    container.append(element);
  }
}

export { addScript, createElement }
