
function selectGroupItems(classNameTable, checkbox, classNameBtns, selectBtn, btnRmv, unSelectBtn, previousCheckboxClass) {
    const tableGroup = document.querySelector(`.${classNameTable}`);
    const groupCheckboxToChangeVisible =  tableGroup.querySelectorAll(`.${checkbox}`);
    const groupBtnToHidden =  document.querySelectorAll(`.${classNameBtns}`);
    const btnRemoveItems = document.querySelectorAll(`.${btnRmv}`);
    const btnSelectItems = document.querySelectorAll(`.${selectBtn}`)
    const btnUnSelectItems = document.querySelectorAll(`.${unSelectBtn}`);
    const btnSelectItemsAll = document.querySelectorAll('.btn-selectitemsall');

    if ($('.table__input-remove').length == 0) {
        jalert(lang.Missing_elem_alert);
        return;
    }

    btnSelectItemsAll.forEach( btn => {
        btn.value = lang.Select_items_all;
    });

    if(previousCheckboxClass === 'checkbox_calc') {
        const prevCheckboxes = document.querySelectorAll(`.${previousCheckboxClass}`);
        prevCheckboxes.forEach(checkbox => {
            if(checkbox.style.display !== "none") {
                checkbox.style.display = "none";
            } else {
                checkbox.style.display = "inline";
            }
        });
    }

    groupCheckboxToChangeVisible.forEach(checkbox => {
        checkbox.checked = false;
        if(checkbox.style.display !== "inline") {
            checkbox.style.display = "inline";
        } else {
            checkbox.style.display = "none";
        }
    });


    btnSelectItemsAll.forEach(btn => {
        if(btn.style.display !== "inline") {
            btn.style.display = "inline";
        } else {
            btn.style.display = "none";
        }
    })


    groupBtnToHidden.forEach(btn => {
        if(btn.style.display !== "none") {
            btn.style.display = "none";
        } else {
            btn.style.display = "inline";
        }
    });
    btnSelectItems.forEach(btn => {
        if(btn.style.display !== "none") {
            btn.style.display = "none";
        } else {
            btn.style.display = "inline";
        }
    })
    btnRemoveItems.forEach(btn => {
        if(btn.style.display !== "inline") {
            btn.style.display = "inline";
        } else {
            btn.style.display = "none";
        }
    })
    btnUnSelectItems.forEach(btn => {
        if(btn.style.display !== "inline") {
            btn.style.display = "inline";
        } else {
            btn.style.display = "none";
        }
    })
}

function selectGroupItemsAll(classNameTable) {
    const tableGroup = document.querySelector(`.${classNameTable}`);
    const groupCheckbox =  tableGroup.querySelectorAll('.table__input-remove');
    const arrGroupCheckbox = Array.from(groupCheckbox);
    const btnSelectItemsAll = document.querySelectorAll('.btn-selectitemsall');
    btnSelectItemsAll.forEach(btn => {
        if(btn.value === lang.Select_items_all) {
            arrGroupCheckbox.forEach( checkbox => {
                checkbox.checked = true;
            });
            btn.value = lang.Remove_marks;
        } else {
            arrGroupCheckbox.forEach( checkbox => {
                checkbox.checked = false;
            });
            btn.value = lang.Select_items_all;
        }
    })

}

function deleteGroupItems(classNameTable, itemName, table, group) {
    const arrGroupCheckboxChecked = [];
    const tableGroup = document.querySelector(`.${classNameTable}`);
    const groupCheckbox =  tableGroup.querySelectorAll('.table__input-remove');
    const arrGroupCheckbox = Array.from(groupCheckbox);
    arrGroupCheckbox.forEach(item => {
        if(item.checked === true) {
            arrGroupCheckboxChecked.push(item);
        }
    });
    if(arrGroupCheckboxChecked.length === 0) {
        return jalert(lang.Select_elem_alert);
    }
    else {
        jconfirm(lang.Delete_elem_alert, function () {
            const preloaderList = document.getElementsByClassName('preloader__block hidden');
            if (preloaderList[0]) {
              preloaderList[0].classList.remove('hidden');
            }

            const preloaderBlock = document.querySelector('.preloader__block');
            if (preloaderBlock) {
              preloaderBlock.style.top = "350px";
              preloaderBlock.style.height = "5%";
            }

            const activeForm = $(groupCheckbox).parents('form');
            const actionValue = activeForm.attr('action');

            // Для удаления полей и групп полей
            if ( itemName === "field" ) {
                let fieldsArray = [];
                let fgroupArray = [];

                arrGroupCheckboxChecked.forEach(item => {
                    // Не групповое поле
                    if(!item.dataset.checkboxRemoveGroupId) {
                        fieldsArray.push(item.dataset.checkboxRemoveId)
                    }
                    // Групповое поле
                    else {
                        fgroupArray.push(item.dataset.checkboxRemoveGroupId)
                    }
                });

                // Создаем форму с необходимыми полями
                const newForm = $(document.createElement('form'));
                newForm.attr('id', 'newForm');
                newForm.attr('action', actionValue);
                newForm.attr('method', 'post');
                newForm.css('display','none');
                const fieldsInput = $(document.createElement('input'));
                newForm.append(fieldsInput);
                fieldsInput.attr('name', 'fields');
                fieldsInput.val(fieldsArray);

                const fgroupsInput = $(document.createElement('input'));
                newForm.append(fgroupsInput);
                fgroupsInput.attr('name', 'fgroups');
                fgroupsInput.val(fgroupArray);

                const deleteInput = $(document.createElement('input'));
                newForm.append(deleteInput);
                deleteInput.attr('name', 'delete');

                const csrfInput = $(document.createElement('input'));
                newForm.append(csrfInput);
                csrfInput.attr('name', 'csrf');
                csrfInput.val(csrf);

                $('body').append(newForm)
                newForm.submit()

            } else if ( itemName === "calc" ) {
                let calcsArray = [];
                arrGroupCheckboxChecked.forEach(item => {
                    calcsArray.push(item.dataset.checkboxRemoveId)
                });

                // Создаем форму с необходимыми полями
                const newForm = $(document.createElement('form'));
                newForm.attr('id', 'newForm');
                newForm.attr('action', actionValue);
                newForm.attr('method', 'post');
                newForm.css('display','none');
                const calcsInput = $(document.createElement('input'));
                newForm.append(calcsInput);
                calcsInput.attr('name', 'calcs');
                calcsInput.val(calcsArray);

                const deleteInput = $(document.createElement('input'));
                newForm.append(deleteInput);
                deleteInput.attr('name', 'sel');
                deleteInput.val('delete_calc');

                const csrfInput = $(document.createElement('input'));
                newForm.append(csrfInput);
                csrfInput.attr('name', 'csrf');
                csrfInput.val(csrf);

                $('body').append(newForm)
                newForm.submit()

            } else if ( itemName === "button" ) {
                let buttonsArray = [];
                arrGroupCheckboxChecked.forEach(item => {
                    buttonsArray.push(item.dataset.checkboxRemoveId)
                });

                // Создаем форму с необходимыми полями
                const newForm = $(document.createElement('form'));
                newForm.attr('id', 'newForm');
                newForm.attr('action', actionValue);
                newForm.attr('method', 'post');
                newForm.css('display','none');
                const buttonsInput = $(document.createElement('input'));
                newForm.append(buttonsInput);
                buttonsInput.attr('name', 'buttons');
                buttonsInput.val(buttonsArray);

                const deleteInput = $(document.createElement('input'));
                newForm.append(deleteInput);
                deleteInput.attr('name', 'delete');

                const csrfInput = $(document.createElement('input'));
                newForm.append(csrfInput);
                csrfInput.attr('name', 'csrf');
                csrfInput.val(csrf);

                $('body').append(newForm)
                newForm.submit()
            }
        });
    }
}


