import React, { useState, useEffect, useRef, createContext, useContext, useReducer } from 'react';
import ReactDOM from 'react-dom';
import axios from 'axios';
import Print from './parts/Print/Print';
import Export from './parts/Export/Export';
import Preloader from './parts/Preloader/Preloader';
import moment from 'moment-with-locales-es6';
import { Accordion, AccordionItem } from 'react-light-accordion';


function genid() {
  var dt = new Date().getTime();
  var mask = 'ixxxyxxx';
  return mask.replace(/[xy]/g, function(c) {
      var r = (dt + Math.random()*16)%16 | 0;
      dt = Math.floor(dt/16);
      return (c=='x' ? r :(r&0x3|0x8)).toString(36);
  });
}

function emitAttrs(item, alignment = null) {
  console.log(item);
  let props = item.properties || {};
  let width = parseFloat(item.width || 100);
  if (width>0 && width<=100 && item.type=='block') {
    props.flex = ' 0 0 '+(width-(.69*2))+'%';
  }
  if (item.type=='block') {
    props.order = parseInt(item.order || 0);
  }
  let classes = item.classes || {};
  let attrs = item.attributes || {};

  if(alignment != null){
    props['textAlign'] = alignment;
  }
  attrs.style = props;
  if (item.tag == 'a') attrs.className = 'table-cell__word-break';

  return attrs;
}

function emitText(item, context) {
  var text = typeof item.content == 'string' ? item.content : (typeof item == 'string' ? item : '');
  return text.replace(/~~(.*?)~~/gu, (x) => {
    let name = x.substr(2,x.length-4);
    let result = context[name];
    let resultText = (result instanceof Object && result['__REPCON_ARRAY_DEFAULT_VALUE__'])
            ? result['__REPCON_ARRAY_DEFAULT_VALUE__']
            : (
                (
                  typeof result == 'object' ||
                  typeof result == 'undefined' ||
                  typeof result == 'function'
                  )
                ? ''
                : result);

    return changeTextForHTMLDisplay(resultText);
  });
}

function changeTextForHTMLDisplay(text) {
  if (typeof text !== 'string') text = text.toString();

  text = text.replaceAll('<br/>', '');
  text = text.replaceAll('<br>', '');
  text = text.replaceAll('</br>', '');
  text = text.replaceAll('\n\r', '<br>');
  text = text.replaceAll('\r\n', '<br>');
  text = text.replaceAll('\n', '<br>');
  return text;
}

function createMarkupText(text) {
  return {__html: text};
}

function checkTextLength(text) {
  const txtParts = text.split(' ');
  let isTooLong = false;

  txtParts.forEach(function(part) {
    if (part.length > 100) {
      isTooLong = true;
    }
  });

  return isTooLong;
}

function ElementContent(props) {
  const textContent = emitText(props.item,props.dataset);
  const isLongText = checkTextLength(textContent);
  const cellsClass = isLongText ? 'report--table-cell__text-long' : 'report--table-cell__text';

  return props.item.layout instanceof Array
    ? props.item.layout.map(item => { return <Element key={genid()} item={item} dataset={props.dataset} alignment={props.alignment} /> })
    : <div className={cellsClass} dangerouslySetInnerHTML={createMarkupText(textContent)} />;
}

function Element(props) {
  let item = props.item;
  let alignment = (props.alignment || 'center').toString();
  if (item.href) {
    item.tag = 'a';
    let fine_href = emitText(item.href,props.dataset);
    if (item.attributes instanceof Object) {
      item.attributes.href = fine_href;
    } else {
      item.attributes = { href:fine_href };
    }
  }
  switch (item.tag || props.defaultTag) {
    case 'a':
      return <a {...emitAttrs(item)}><ElementContent item={item} dataset={props.dataset} alignment={alignment} /></a>;
    case 'td':
      return <td {...emitAttrs(item, alignment)}><ElementContent item={item} dataset={props.dataset} alignment={alignment} /></td>;
    case 'th':
      return <th {...emitAttrs(item, alignment)}><ElementContent item={item} dataset={props.dataset} alignment={alignment} /></th>;
    case 'div':
      return <div {...emitAttrs(item)}><ElementContent item={item} dataset={props.dataset} alignment={alignment} /></div>;
    case 'span':
    default:
      return <span {...emitAttrs(item)}><ElementContent item={item} dataset={props.dataset} alignment={alignment} /></span>;
  }
}

function Block(props) {
  return (
      <div className="yamlview__block" {...emitAttrs(props.item)}>
        <div className="yamlview__block_inner">
          <div className="yamlview__block_layout">
            <Layout layout={props.item.layout} dataset={props.dataset} />
          </div>
        </div>
      </div>
  );
}

function TableBody(props) {
  var keys = (Object.keys(props.dataset)).filter(i => {return i===parseInt(i,10).toString()});

  return keys.map(item => { return (
    <tr key={genid()}>
      {props.layout.map((i) => {
        return (<Element key={genid()} item={i} dataset={props.dataset[item]} defaultTag="td" alignment={props.alignment} />)
      })}
    </tr>
  )})
}

function Table(props) {
  var context = {};
  if (props.item.data) {
    Object.assign(context,props.dataset[props.item.data]);
  }
  Object.assign(context,props.dataset);
  return (
    <AccordionItem title={props.item.caption ? emitText(props.item.caption,context) : null}>
    <div className="yamlview__block">
      <div className="yamlview__block_inner">
        <table {...emitAttrs(props.item)}>
          {props.item.head ?
            <thead><tr>
            {props.item.head.map((i)=>{
              return (<th key={genid()} {...emitAttrs(i)} style={{textAlign: props.item.alignment.toString()}}>{emitText(i,context)}</th>)
            })}
          </tr></thead> : null}
          {props.item.body ? <tbody>
            <TableBody layout={props.item.body} dataset={context} alignment={props.item.alignment} />
          </tbody> : null}
          {props.item.foot ? <tfoot><tr>
            {props.item.foot.map((i)=>{
              return (<td key={genid()} {...emitAttrs(i)}  style={{textAlign: props.item.alignment.toString(), fontWeight: 'bold' }}>{emitText(i,context)}</td>)
            })}
          </tr></tfoot> : null}
        </table>
        {props.item.showCount &&
          <div className='report__table--total-line'>
            {lang.Total_lines}: {context.count}
          </div>
        }
      </div>
    </div>
    </AccordionItem>
  )
}

function Layout(props) {
  return props.layout instanceof Array ? props.layout.map((item) => {
    switch (item.type) {
      case 'block':
        return <Block key={genid()} item={item} dataset={props.dataset} />;
      case 'table':
        return <Table key={genid()} item={item} dataset={props.dataset} />;
      case 'element':
      default:
        return <Element key={genid()} item={item} dataset={props.dataset} defaultTag="div" />;
    }
  }) : null;
}

function JQueryUIDatePicker(props) {
  const dpEl = useRef(null);

  function updatePeriod(curValue) {
    const maxWidthOfButtonVisible = 480; // Максимальная ширина окна для отображения кнопки "Обновить" (задано css-стилями)
    const windowWidth = window.innerWidth; // Ширина отображаемого окна
    const dateRegExp = /^\d{2}(\.|\/)\d{2}(\.|\/)\d{4}/ig; // регулярное выражение для даты
    const updateBtn = $('.yamlview__params').find('input[type=button][value=' + lang.Refresh + ']');

    if (curValue.length === 10 && windowWidth < maxWidthOfButtonVisible && dateRegExp.test(curValue)) {
      setTimeout(() => (updateBtn.trigger('click')), 300);
    }
  }

  useEffect(() => {
    $(function () {
      $(dpEl.current).datepicker({
          showOn: "focus",
          showAlways: true,
          buttonImage: "images/calbtn.png",
          buttonImageOnly: true,
          onSelect: (value) => { props.assignValue(value); },
      }).attr('placeholder', lang.date_placeholder);
    })
    return () => {
      $(dpEl.current).datepicker('destroy');
    }
  }, []);

  return <input ref={dpEl} type="text" value={props.value} className={props.className} size={props.size}
                onChange={e=>{props.assignValue(e.target.value); updatePeriod(e.target.value);}}
                />
}

function ParamPeriod({param, query}) {
  const dispatch = useContext(ReportViewDispatch);

  function movePeriod(disp) {
    let date = query.split('|'), temp;
    switch (param.default) {
      case 'week':
          temp = moment(date[0],'DD.MM.YYYY').add(disp,'week');
          date[0] = temp.startOf('week').format('DD.MM.YYYY');
          date[1] = temp.endOf('week').format('DD.MM.YYYY');
          break;
      case 'month':
        temp = moment(date[0],'DD.MM.YYYY').add(disp,'month');
        date[0] = temp.startOf('month').format('DD.MM.YYYY');
        date[1] = temp.endOf('month').format('DD.MM.YYYY');
        break;
      case 'year':
        temp = moment(date[0],'DD.MM.YYYY').add(disp,'year');
        date[0] = temp.startOf('year').format('DD.MM.YYYY');
        date[1] = temp.endOf('year').format('DD.MM.YYYY');
        break;
      case 'day':
        temp = moment(date[0],'DD.MM.YYYY').add(disp,'day');
        date[0] = temp.format('DD.MM.YYYY');
        date[1] = temp.format('DD.MM.YYYY');
        break;
      case 'half_month':
      default:
        temp = moment(date[0],'DD.MM.YYYY').add(disp*15+1,'day');
        if (temp.date()<=15) {
          date[0] = temp.startOf('month').format('DD.MM.YYYY');
          date[1] = temp.date(15).format('DD.MM.YYYY');
        } else {
          date[0] = temp.date(16).format('DD.MM.YYYY');
          date[1] = temp.endOf('month').format('DD.MM.YYYY');
        }
        break;
    }
    dispatch({type:'set',name:param.name,value:date.join('|')});
  }

  let date = query.split('|');
  return (
    <>
      <input type="button" value="<" className="btn btn-default btn-sm report__change-param--btn" onClick={e=>{movePeriod(-1);dispatch({type:'getdata'});}}/> &nbsp;
      <JQueryUIDatePicker value={date[0]} className='form-control form-control-75 report__change-param--input' size="10"
                assignValue={value=>{dispatch({type:'setlow',name:param.name,value:value});}} />
      &nbsp; - &nbsp;
      <JQueryUIDatePicker value={date[1]} className='form-control form-control-75 report__change-param--input' size="10"
                assignValue={value=>{dispatch({type:'sethigh',name:param.name,value:value});}} /> &nbsp;
      <input type="button" value=">" className="btn btn-default btn-sm report__change-param--btn" onClick={e=>{movePeriod(+1);dispatch({type:'getdata'});}}/>
    </>
  )
}

function ReportParameters({params, values}) {
  const dispatch = useContext(ReportViewDispatch);

  return (
    <div className='yamlview__params'>
      <table style={{margin:'0 auto'}}>
        <tbody>
          <tr>
            <td>
              <span className='input_element'>
                {params.map(param => {
                  switch (param.datatype) {
                    case 'period':
                      return <ParamPeriod key={param.name} param={param} query={values[param.name]} />
                    case 'datetime':
                      return (<>
                        &nbsp; {param.label} &nbsp;
                        <JQueryUIDatePicker key={param.name} value={values[param.name]} className='form-control form-control-75' size="10"
                                            assignValue={value=>{dispatch({type:'set',name:param.name,value:value});}}/>
                        </>)
                    default:
                      return <span> {param.name} = {param.value} </span>
                  }
                } ) }
              </span>
            </td>
            <td>
              <input type="button" value={lang.Refresh} onClick={e=>{dispatch({type:'getdata'})}} className="btn btn-default btn-sm"/>
            </td>
          </tr>
        </tbody>
      </table>
    </div>
  )
}

function ReportTitle({report, exportData, uidata}) {
  return (
    <>
      <div className="yamlview__title">
        <div className='yamlview__title-wrapper'>
          {report.name}
          {user['group_id'] == '1' &&
            <a href={'edit_report.php?report='+report.id} title={lang.edit_report} className="no_print" target="_blank" style={{textDecoration:'none'}}>
              <img className="settings_t" style={{margin:'0 0 8px 8px'}} src="images/settings_b.gif" border="0" />
            </a>
          }
        </div>
        <div className='yamlview__title-wrapper' style={{display: 'flex', alignItems: 'center'}}>
          <AutoUpdateDiv uidata={uidata}/>
          <DropDownMenu exportData={exportData}/>
        </div>
      </div>
    </>
  )
}

function DropDownMenu({exportData}) {
  const [state, setState] = useState({ isVisible: false });
  const wrapperRef = useRef(null);
  useOutsideAlerter(wrapperRef);

  // Функция для отслеживания клика вне компонента
  function useOutsideAlerter(ref) {
    function handleClickOutside(event) {
      if (ref.current && !ref.current.contains(event.target)) {
        setState({
            isVisible: false
        });
      }
    }

    useEffect(() => {
      document.addEventListener("mousedown", handleClickOutside);
      return () => {
        document.removeEventListener("mousedown", handleClickOutside);
      };
    });
  };

  const changeMenuVisible = () => {
    setState( prevState => {
      return {
        isVisible: !prevState.isVisible
      }
    });
  };

  return (
      <div
          className={ state.isVisible ? ('flexMenu-viewMore dropMenu__button no_print dropMenu__button--active') : ('flexMenu-viewMore dropMenu__button no_print')}
          title={lang.Additional_actions}
          ref={wrapperRef}
          onClick={changeMenuVisible}
      >
        <ul
            className='flexMenu-popup header__submenu-dropdownmenu'
            style={
              state.isVisible ? (
                {position: 'absolute', display: 'block'}
              ) : (
                {position: 'absolute', display: 'none'}
              )
            }
        >
          <li className='header__submenu-item'>
            <Print title={lang.print_report}/>
          </li>
          <li className='header__submenu-item'>
            <Export exportData={exportData} title={lang.export_as_excel}/>
          </li>
        </ul>
      </div>
  );
}

function AutoUpdateDiv({uidata}) {
  return (
    <div className='autoupdate--date'>
      {uidata.lastUpdated ? <p>{lang.Data_updated}: {uidata.lastUpdated}</p> : null}
    </div>
  );
}

const ReportViewDispatch = createContext(null);

function reportViewReducer(state, action) {
  switch (action.type) {
    case 'set':
      let newv = {};
      newv[action.name] = action.value;
      return { ...state, ...newv };
    case 'setlow':
      let newl = {}, oldl = state[action.name];
      let [,high] = oldl.split('|');
      newl[action.name] = [action.value,high].join('|');
      return { ...state, ...newl };
    case 'sethigh':
      let newh = {}, oldh = state[action.name];
      let [low] = oldh.split('|');
      newh[action.name] = [low,action.value].join('|');
      return { ...state, ...newh };
    case 'reset':
      return { ...action.state };
    case 'getdata':
      return { ...state, ...{getdata:'getdata'} };
    default:
      throw new Error();
  }
}

function ReportView() {
  const [data, setData] = useState({ report:{}, data:[], layout:[], params:[] });
  const [values, dispatch] = useReducer(reportViewReducer, {});
  const [UIData, setUIData] = useState({isLoading: false, lastUpdated: dateNow()});

  function dateNow() {
    return moment().format("DD-MM-YYYY HH:mm:ss");
  }

  function assignData(newdata) {
    setData(newdata);
    let vls = {};
    newdata.params.forEach(param=>{
      switch (param.datatype) {
        case 'period':
          let low_date = moment(param.value.low).format('DD.MM.YYYY');
          let high_date = moment(param.value.high).format('DD.MM.YYYY');
          vls[param.name] = [low_date,high_date].join('|');
          break;
        case 'datetime':
          vls[param.name] = moment(param.value).format('DD.MM.YYYY');
          break;
        default:
          vls[param.name] = param.value;
          break;
      }
    })
    vls.getdata = null;
    dispatch({type:'reset',state:vls});
  }

  useEffect(() => {
    assignData(rapps_root_report_view_data);
  }, []);

  useEffect(() => {
    let ignore = false;

    async function fetchData() {
      setUIData({isLoading: true});
      let params = {...values};
      params.id = data.report.id;
      params.getdata = 'getdata';
      const result = await axios('report.php',{ params: params });
      if (!ignore) assignData(result.data);
      setUIData({isLoading: false, lastUpdated: dateNow()});
      if ( false ) { // Заменить проверку на настройку с бэка + добавить стейт на прелоудер, если его не нужно будет показывать при автообновлении
        setUIData({lastUpdated: dateNow()});
      }
    }

    if (values.getdata=='getdata') fetchData();

    return () => { ignore = true; }
  }, [values.getdata]);

  // Автообновление данных
  if ( false ) { // Заменить проверку на настройку с бэка + добавить стейт на прелоудер, если его не нужно будет показывать при автообновлении
    useEffect(() => {
      const interval = setInterval(() => {
        dispatch({type:'getdata'});
      }, 10000);
      return () => clearInterval(interval);
    }, []);
  }

  if (typeof data == 'object') { // Если data - JSON object
    return data.report.id ? (
        <ReportViewDispatch.Provider value={dispatch}>
          <ReportTitle report={data.report} exportData={data} uidata={UIData} />
          {data.params.length>0 ? <ReportParameters params={data.params} values={values} /> : null}
          <div className="yamlview">
            <div className="yamlview__block_layout">
              <Accordion atomic={true}>
                <Layout layout={data.layout} dataset={data.data} />
              </Accordion>
            </div>
          </div>
          {UIData.isLoading ? <Preloader /> : null}
        </ReportViewDispatch.Provider>
    ) : (<Preloader />)
  } else {
    reportCbDie(data);
  }
}

function reportCbDie(errorHtml) {
  document.getElementsByTagName('html')[0].innerHTML = errorHtml;
}

ReactDOM.render(React.createElement(ReportView), document.querySelector("#rapps-root-report-view"));
