<?php

require_once __DIR__ . '/../../vendor/autoload.php'; 
//Класс-прокси для перехода на новую библиотеку

class mPDF extends \Mpdf\Mpdf
{
	public function __construct($mode = '', $format = 'A4', $default_font_size = 0, $default_font = '', $mgl = 15, $mgr = 15, $mgt = 16, $mgb = 16, $mgh = 9, $mgf = 9, $orientation = 'P')
	{
		$fontDir = __DIR__ . '/ttfonts'; //директория с файлами шрифтов
		

		parent::__construct([
			'tempDir' => __DIR__ . '/../../temp',
			'format' => $format,
			'margin_left' => $mgl,
			'margin_right' => $mgr,
			'margin_top' => $mgt,
			'margin_bottom' => $mgb,
			'orientation' => $orientation,
			'fontDir' => array_merge((new \Mpdf\Config\ConfigVariables())->getDefaults()['fontDir'], [$fontDir]),
            'fontdata' => array_merge((new \Mpdf\Config\FontVariables())->getDefaults()['fontdata'], [
				// Пример заполнения масива шрифтов:
                // 'rubik' => [
                //     'R'  => 'Rubik-Regular.ttf',
                //     'B'  => 'Rubik-Bold.ttf',
                //     'I'  => 'Rubik-Italic.ttf',
                //     'BI' => 'Rubik-BoldItalic.ttf',
                // ],
			]),
		]);
	}
}