import React, { useEffect } from 'react';
import { AccordionItem } from 'react-light-accordion';

export default ({ index, item, deleteError, openField }) => {
    const titles = {
        MATCHING_MANY_ITEMS: "Несколько объектов сопоставления.",
        MUTUAL_CHANGE: "Взаимное обновление записи.",
        OBJECT_NOT_FOUND: "Запрашиваемая запись не найдена.",
        TABLE_NOT_FOUND: "Таблица не найдена.",
        FIELD_NOT_FOUND: "Поле не найдено.",
        FIELD_DATATYPE_INVALID: "Некорректный тип поля.",
        TABPART_FIELD_NOT_FOUND: "Не найдено поле подтаблицы.",
        TABPART_FIELD_DATATYPE_INVALID: "Некорректный тип поля подтаблицы.",
        PROPERTY_NOT_FOUND: "Поле не найдено.",
        PROPERTY_CANNOT_CHANGED: "Поле не может быть изменено.",
        TABPART_PROPERTY_NOT_FOUND: "Поле подтаблицы не найдено.",
        TABPART_PROPERTY_CANNOT_CHANGED: "Поле подтаблицы не может быть изменено."
    }

    const chunks = {
        TABPART: "подтаблицы",
        FIELD: "Поле",
        TABLE: "Таблица",
        TABLES: "таблицы"
    }

    useEffect(() => {
        $('.accordion-item button.title').click((e) => {
            e.preventDefault();
            let height = $(e.target).parents('.accordion-item').find('form').height();
            if($(e.target).parents('.accordion-item').hasClass('active')){
                $(e.target).parents('.accordion-item').find('.panel').css('max-height', 0);
            }
            else {
                $(e.target).parents('.accordion-item').find('.panel').css('max-height', height);
            }
        });
    });

    function createBlock() {
        if(item.code == "MATCHING_MANY_ITEMS"){
            return (
                <form method="post">
                    <div className="error_container">
                        <div className="error_description">
                            При процедуре сопоставления найдено несколько объектов.
                        </div>
                        <div className="error_correction_block">
                            Обновляемые значения:
                            <table border="1">
                                <tr>
                                    <th>Наименование поля</th>
                                    <th>Значение</th>
                                </tr>
                                {Object.keys(item.data_update_display).map((i) => {
                                    return (
                                        <tr className="error_display_data_item">
                                            <td>{i}</td><td>{item.data_update_display[i]}</td>
                                        </tr>
                                    );
                                })}
                            </table>
                            ID всех подходящих записей:
                            {item.ids.map((id, index) => {
                                let link = "view_line2.php?table=" + item.table_cb_id + "&line=" + id;

                                return (
                                        <>
                                            <a href={link} target="_blank">{id}</a>{index == item.ids.length - 1 ? '' : ','}
                                        </>
                                       );
                            })}
                            <br />
                            Выберите ID нужной записи:
                            <select id="matching_ids" name="matching_id" className="form-control" style={{ width: 'auto', marginLeft: '10px' }}>
                                {item.ids.map(i => (
                                    <option value={i}>{i}</option>
                                ))}
                            </select>
                        </div>
                        <div className="input-block" style={{ textAlign: 'center' }}>
                            <input type='hidden' name='error_id' value={index} />
                            <input type='hidden' name='csrf' value={csrf} />
                            <input type='submit' name="repair_error" id='del-save-btn' className='btn btn-default btn-sm save-settings-btn' value="Исправить" />
                            <input type='submit' name="delete_error" id='del-save-btn' className='btn btn-default btn-sm save-settings-btn' value="Удалить" />
                        </div>
                    </div>
                </form>
            );
        }
        else if(item.code == "MUTUAL_CHANGE"){
            let link = "view_line2.php?table=" + item.table_cb_id + "&line=" + item.line_id;
            return (
                <form method="post">
                    <div className="error_container">
                        <div className="error_description">
                            Одновременное обновление данных одной и той же <a href={link} target="_blank">записи</a>.
                        </div>
                        <div className="error_correction_block">
                            Обновляемые значения:
                            <table border="1">
                                <tr>
                                    <th></th>
                                    <th>1C</th>
                                    <th>КБ</th>
                                </tr>
                                {Object.keys(item.item_cb_display).map((i) => {
                                    return (
                                        <tr className="error_display_data_item">
                                            <td>{i}</td>
                                            <td>{item.item_1c_display[i]}</td>
                                            <td>{item.item_cb_display[i]}</td>
                                        </tr>
                                    );
                                })}
                            </table>
                            Выберите чьи данные считать истинными:
                            <select id="mutual_ids" name="mutual_id" className="form-control" style={{ width: 'auto', marginLeft: '10px' }}>
                                <option value="0">1C</option>
                                <option value="1">КБ</option>
                            </select>
                        </div>
                        <div className="input-block" style={{ textAlign: 'center' }}>
                            <input type='hidden' name='error_id' value={index} />
                            <input type='hidden' name='csrf' value={csrf} />
                            <input type='submit' name="repair_error" id='del-save-btn' className='btn btn-default btn-sm save-settings-btn' value="Исправить" />
                            <input type='submit' name="delete_error" id='del-save-btn' className='btn btn-default btn-sm save-settings-btn' value="Удалить" />
                        </div>
                    </div>
                </form>
            );
        }
        else if(item.code == "OBJECT_NOT_FOUND"){
            return (
                <form method="post">
                    <div className="error_container">
                        <div className="error_description">
                            Запись с GUID'ом <i>{item.guid}</i> таблицы <b><i>{item.object}</i></b>(<i>{item.table_cb_name}</i>) не найдена.
                        </div>
                        <div className="error_correction_block">
                        </div>
                        <div className="input-block" style={{ textAlign: 'center' }}>
                            <input type='hidden' name='error_id' value={index} />
                            <input type='hidden' name='csrf' value={csrf} />
                            <input type='submit' name="delete_error" id='del-save-btn' className='btn btn-default btn-sm save-settings-btn' value="Удалить" />
                        </div>
                    </div>
                </form>
            );
        }
        else if(item.code.indexOf("NOT_FOUND") !== -1){
            let text_msg = () => {
                if(item.code.indexOf('TABPART') !== -1){
                    return(<>{chunks.FIELD} <i>{item.params.tabpart_field}</i> {chunks.TABPART} <i>{item.params.field}</i> {chunks.TABLES} <b><i>{item.params.table}</i></b> не найдено!</>);
                }
                else if(item.code.indexOf('TABLE') !== -1){
                    return(<>{chunks.TABLE} <b><i>{item.params.table}</i></b> не найдена!</>);
                }
                else {
                    return(<>{chunks.FIELD} <i>{item.params.field}</i> {chunks.TABLES} <b><i>{item.params.table}</i></b> не найдено!</>);
                }
            }
            return (
                <form method="post">
                    <div className="error_container">
                        <div className="error_description">
                            {text_msg()} <br/><br/>
                            Удалите/измените сопоставление с {item.code.indexOf('TABLE') !== -1 ? 'данной таблицей' : 'данным полем'} и после этого удалите ошибку.
                        </div>
                        <div className="error_correction_block">
                        </div>
                        <div className="input-block" style={{ textAlign: 'center' }}>
                            <input type='hidden' name='error_id' value={index} />
                            <input type='hidden' name='csrf' value={csrf} />
                            <input type='submit' name="open_conf" id='del-save-btn' className='btn btn-default btn-sm save-settings-btn' value="Открыть конфигурацию" onClick={openField} />
                            <input type='submit' name="delete_error" id='del-save-btn' className='btn btn-default btn-sm save-settings-btn' value="Удалить" />
                        </div>
                    </div>
                </form>
            );
        }
        else if(item.code.indexOf("DATATYPE_INVALID") !== -1){
            let text_msg = () => {
                if(item.code.indexOf('TABPART') !== -1){
                    return (<>{chunks.FIELD} <i>{item.params.tabpart_field}</i> {chunks.TABPART} <i>{item.params.field}</i> {chunks.TABLES} <b><i>{item.params.table}</i></b> неправильный тип данных!</>);
                }
                else {
                    return(<>{chunks.FIELD} <i>{item.params.field}</i> {chunks.TABLES} <b><i>{item.params.table}</i></b> неправильный тип данных!</>);
                }
            }
            return (
                <form method="post">
                    <div className="error_container">
                        <div className="error_description">
                            {text_msg()} <br/><br/>
                            Удалите/измените сопоставление с данным полем и после этого удалите ошибку.
                        </div>
                        <div className="error_correction_block">
                        </div>
                        <div className="input-block" style={{ textAlign: 'center' }}>
                            <input type='hidden' name='error_id' value={index} />
                            <input type='hidden' name='csrf' value={csrf} />
                            <input type='submit' name="open_conf" id='del-save-btn' className='btn btn-default btn-sm save-settings-btn' value="Открыть конфигурацию" onClick={openField} />
                            <input type='submit' name="delete_error" id='del-save-btn' className='btn btn-default btn-sm save-settings-btn' value="Удалить" />
                        </div>
                    </div>
                </form>
            );
        }
        else if(item.code.indexOf("CANNOT_CHANGED") !== -1){
            let text_msg = () => {
                if(item.code.indexOf('TABPART') !== -1){
                    return (<>{chunks.FIELD} <i> {item.params.tabpart_field} </i> {chunks.TABPART} <i>{item.params.field}</i> {chunks.TABLES} <b><i>{item.params.table}</i></b> не удалось записать в 1С!</>);
                }
                else {
                    return (<>{chunks.FIELD} <i>{item.params.field}</i> {chunks.TABLES} <b><i>{item.params.table}</i></b> не удалось записать в 1С!</>);
                }
            };


            let link = "view_line2.php?table=" + item.params.table_cb_id + "&line=" + item.params.line_id;
            return (
                <form method="post">
                    <div className="error_container">
                        <div className="error_description">
                                {text_msg()} <br/><br/>
                                Убедитесь, что поле <a href={link} target="_blank">данной записи</a> записано в корректном формате.
                            </div>
                            <div className="error_correction_block">
                            </div>
                            <div className="input-block" style={{ textAlign: 'center' }}>
                                <input type='hidden' name='error_id' value={index} />
                                <input type='hidden' name='csrf' value={csrf} />
                                <input type='submit' name="open_conf" id='del-save-btn' className='btn btn-default btn-sm save-settings-btn' value="Открыть конфигурацию" onClick={openField} />
                                <input type='submit' name="delete_error" id='del-save-btn' className='btn btn-default btn-sm save-settings-btn' value="Удалить" />
                            </div>
                    </div>
                </form>
            );
        }
    }

    return (
        <AccordionItem title={titles[item.code]}>
            {createBlock()}
        </AccordionItem>
    );
}
