const fields = {
  //Сопоставление таблиц КБ и объектов внешнего приложения
  connectors: {
    name: {
      type: "input-text",
      default: "",
      is_list_name: "table",
      required: true,
      help: "gpt_table_name",
    },

    instant: {
      type: "dropdown",
      options: {
        0: "Отложенная обработка (по cron)",
        1: "Сразу после получения запроса",
      },
      default: 1,
      help: "gpt_table_instance",
    },

    internal_object_id: {
      type: "dropdown",
      optionsFrom: {
        source: "tables",
      },
      required: true,
      help: "gpt_internal_object",
    },

    status_service_field: {
      type: "dropdown",
      optionsFrom: {
        source: "fields",
        parent: "internal_object_id"
      },
      help: "gpt_status_service_field",
    },

    "external_action": {
      "type": "dropdown",
      "options": {
          "text_to_text": "Текст - Текст",
          "text_to_image": "Текст - Изображение",
          "image_to_text": "Изображение - Текст",
          "txt_to_text": "Текстовый файл - Текст",
          "text_to_txt": "Текст - Текстовый файл",
          "word_to_text": "Word docx - Текст",
          "word_to_word": "Word docx - Word docx",
          "audio_to_text": "Аудио - Текст",
          "text_to_audio": "Текст - Аудио",
          "text_add_lines": "Текст - Добавление строк"
      },
      "required": true,
      "help": "clientbasegpt_external_action"
    },
    "external_action_params_knowledge_base_dropdown": {
      "type": "dropdown",
      "optionsFrom": {
        source: "options",
        field: "knowledge_base"
      },
      help: "gpt_knowledge_base_dropdown"
    },

    calc: {
      type: "html",
      help: "integration_auto_calc"
    },

    external_action_params_conversations: {
      "type": "checkbox",      
    },    

    fm_conversation_link: {
      "type": "dropdown",
      "optionsFrom": {
        source: "fields",
        parent: "internal_object_id",
        fieldsType: "link",
        hideLinked: true        
      },
      "required": true
    },

    external_action_params_conversations_autodrop: {
      "type": "dropdown",
      "options": {
          "24": "24",
          "8": "8",
          "4": "4",
          "1": "1",
      },
      "required": true
    }
    /*
        'fields_mapping': {
            type: "fields-mapping",
            fieldsFrom: {
                app_object: "external_object_type",
                table: "internal_object_id"
            }
        }
*/
  },

  // Информация
  token_limit: {
    type: "text",
    default: "Использовано {{limit_token_request}}/{{limit_token_generate}} ({{limit_token_percent}}%)",
    help: "gpt_information_token_limit",
  },

  //База знаний

  knowledge: {
    name: {
      type: "input-text",
      required: true,
      default: "",
      help: "gpt_knowledge_name",
    },
    knowledge_tables: {
      type: "objects-list",
      addtext: "add_table",
      noLabel: true,
      help: "gpt_knowledge_table",
      fields: {
        knowledge_table_id: {
          type: "dropdown",
          is_list_name: "table",
          optionsFrom: { source: "tables" },
          required: true
        },
        knowledge_fields_mode: {
          type: "dropdown",
          options: { 0: "Все поля", 1: "Выбрать поля" },
          default: 0,
          required: true
        },
        knowledge_fields: {
          type: "checkbox",
          optionsFrom: { source: "fields", parent: "knowledge_table_id" },
          showOn: "knowledge_fields_mode",
          showOnValue: 1,
        },
        knowledge_fields_filter: {
          type: "dropdown", 
          is_list_name: 'filter',
          optionsFrom: {source: "filters", parent: "knowledge_table_id"},
          default: "",
          nullLabel: "Все записи",
          required: false,
        },
      },
    },

    knowledge_update: {
      type: "checkbox",
      default: 0,
      help: "gpt_knowledge_update",
    },
    knowledge_upload: {
      type: "dropdown",
      options: {
          "0": "Ничего не делать",
          "1": "Отправить на обработку",
          "2": "Сбросить",
      },
      default: 0,
      required: true,
      help: "gpt_knowledge_upload",
    },

    status_upload: {
      type: "text",
      default: "{{status_update}}",
      help: "gpt_knowledge_status_update"
    },
    status_vs: {
      type: "text",
      default: "{{status_vs}}",
      help: "gpt_knowledge_status_vs"
    },
    file_size_kb: {
      type: "text",
      default: "{{file_size_kb}}",
      help: "gpt_knowledge_file_size_kb"
    },
    stor_token: {
      type: "text",
      default: "{{stor_token}}",
      help: "gpt_knowledge_stor_token"
    },
    embend_token: {
      type: "text",
      default: "{{embend_token}}",
      help: "gpt_knowledge_embend_token"
    },
    date_update: {
      type: "text",
      default: "{{date_update}}",
      help: "gpt_knowledge_date_last_update"
    },
  }
};

export default fields;
