//Описываем структуру формы настроек в виде многоуровневого массива
const composition = [

    {
        //Вкладка "Подключения"
        header: 'apps',

        forms: [

            {

                header: "apps_header",

                //Поле содержащее данные 
                data: "app", 

                //field: поле, содержащее массив настроек
                field: "apps",

                formBlocks: [
                    {   
                        message: {
                            template: "{{__error}}"
                        }
                    },
                    {   
                        fields: ["auth_login", "auth_password", "auth_account_id"],
                    },

                ]
            }

        ]

    },

    {
        //Вкладка "Таблицы"
        header: 'tables',

        forms: [

            {

                showOn: 'app',

                header: "prepare_tables",
                
                //listForm=true - форма со списком, управляет массивом настроек
                listForm: true,

                //field: поле, содержащее массив настроек
                field: "tables",

                //addButton: текст ссылки добавления нового элемента
                addButton: "add_table",

                //listFields - поля, которые будут выведены в списке
                listFields: ['name'],


                formBlocks: [
                    { //Общие настройки таблицы
                        fields: ['name', 'external_object_type', 'internal_object_id'],
                    },
                    {
                        header: 'fields_mapping',
                        custom: {
                            'integration-fields-mapping': {
                                app_object: "external_object_type",
                                table: "internal_object_id",
                                help: "saby_fields_mapping"
                            }
                        }
                    }
                ],

                archive: {
                    field: "arc",
                    on: "1",
                    off: "0"
                }                

            },  

            {
                hideOn: 'app',
                saveButton: false,

                formBlocks: [
                    {
                        message: {
                            template: "В ходе активации модуля произошла ошибка, обратитесь в техническую поддержку",
                            status: "alert"
                        }
                    }
                ]
            }


        ]        

    },    

    {
        //Вкладка "Интеграции"
        header: 'connectors',

        forms: [

            {

                showOn: 'app',

                header: "connectors",
                
                //listForm=true - форма со списком, управляет массивом настроек
                listForm: true,

                //field: поле, содержащее массив настроек
                field: "connectors",

                //addButton: текст ссылки добавления нового элемента
                addButton: "add_connector",

                //listFields - поля, которые будут выведены в списке
                listFields: ['name'],


                formBlocks: [
                    { //Общие настройки интеграции
                        fields: ['name']
                    },
                    {
                     //Настройки вызова команда
                        header: 'connector_command_settings',       
                        fields: ['object_mapping_id', 'external_action'],
                        custom: {
                            'integration-fields-mapping': {
                                prefix: "external_action_params_",
                                fieldsList: "params",
                                fieldsType: true,
                                app_object: "external_object_type",
                                app_action: "external_action",
                                table: "internal_object_id",
                                from_list: "tables",
                                from_list_value: "object_mapping_id",
                                help: "saby_command_param"
                            }
                        }                                        
                    },
/*                    
                    { //Настройки интеграции вызова команды
                        showOn: 'type',
                        showOnValue: 'out',
                        header: 'connector_out_settings',
                        fields: ['external_object_type', 'external_action', 'internal_object_id', 'action_event', 'internal_action']
                    },
                    { //Настройки интеграции вебхука
                        showOn: 'type',
                        showOnValue: 'in',
                        header: 'connector_in_settings',
                        fields: ['external_object_type', 'external_hook_action', 'internal_object_id', 'internal_hook_action']                        
                    },
                    { //Настройки синхронизации
                        showOn: 'type',
                        showOnValue: 'sync',
                        header: 'connector_sync_settings',
                        fields: ['external_object_type', 'internal_object_id', 'external_add_records', 'external_delete_records', 'internal_add_records', 'internal_delete_records']
                    },   
                    { //Поле связи
                        formLines: [
                            {
                                label: 'internal_connect_field',
                                fields: ['internal_connect_field']
                            },
                            {
                                showOn: 'internal_connect_field',
                                showOnValue: '1',
                                label: 'internal_connect_field_name',
                                fields: ['internal_connect_field_name']
                            },
                            {
                                showOn: 'internal_connect_field',
                                showOnValue: '2',
                                label: 'internal_connect_field_id',
                                fields: ['internal_connect_field_id']
                            }
                        ]
                    },
*/                    
                    
                    {
                        showOn: 'object_mapping_id',
                        header: 'fields_mapping',
                        custom: {
                            'integration-fields-mapping': {
                                app_object: "external_object_type",
                                app_action: "external_action",
                                table: "internal_object_id",
                                from_list: "tables",
                                from_list_value: "object_mapping_id",
                                help: "saby_fields_mapping"
                            }
                        }
                        
                    },
/*
                    {
                        hideOn: 'cron_id',
                        header: 'calc_conditions',
                        custom: {
                            'calc-conditions': {
                                fieldCond: "calc_cond",
                                fieldPeriod: "cron_period",
                                table: "internal_object_id",
                                from_list: "tables",
                                from_list_value: "object_mapping_id",
                                label: 'calc_conditions',
                                help: "saby_run_conditions"                         
                            }
                        }
                        //fields: ['calc_id'],
                    },                    

                    {
                        showOn: 'calc_id',
                        fields: ['calc']
                    },

                    {
                        showOn: 'cron_id',
                        fields: ['cron']
                    },

                    {
                        showOn: 'button_id',
                        fields: ['button']
                    },                    
*/

                ],

                archive: {
                    field: "arc",
                    on: "1",
                    off: "0"
                },
                
                activity:  {
                    field: "disabled",
                    on: 0,
                    off: 1
                },

                //copy: true,

                alert: {
                    field: "__error"
                }                

            },  

            {
                hideOn: 'app',
                saveButton: false,

                formBlocks: [
                    {
                        message: {
                            template: "В ходе активации модуля произошла ошибка, обратитесь в техническую поддержку",
                            status: "alert"
                        }
                    }
                ]
            }            


        ]

    },

    {
        //Вкладка "Настройки"
        header: 'settings',

        forms: [
            {
                formBlocks: [
                    {
                        fields: ['own_rules_fields']
                    },
                    {
                        showOn: 'own_rules_fields',
                        showOnValue: "yes",
                        fields: ['rules_file', 'rules_docid', 'rules_status', 'rules_our_company', 'rules_recipient', 'rules_inn', 'rules_kpp']
                    },
                    {
                        fields: ['own_rules_status']
                    },
                    {
                        showOn: 'own_rules_status',
                        showOnValue: "yes",
                        fields: ['rules_statuses', 'rules_cronperiod']
                    },
                    {
                        fields: ['own_rules_names']
                    },
                    {
                        showOn: 'own_rules_names',
                        showOnValue: "yes",
                        fields: ['rules_buttonname']
                    }                                         
                ]
            }
        ]
    }


];

export default composition;