import useAdditionallyTabWazzupExtensionStore from './../../store/useAdditionallyTabWazzupExtensionStore.js';
import useChannelsTabWazzupExtensionStore from './../../store/useChannelsTabWazzupExtensionStore.js';

export const DefaultChannel = {
  name: 'default-channel',

  setup(props, {emit}) {
    const additionallyStore = useAdditionallyTabWazzupExtensionStore();
    const channelStore = useChannelsTabWazzupExtensionStore();

    Vue.onMounted(() => {
      checkHelpButtonsOnCurrentPage();
      bind_help_bt('wazzup');

      additionallyStore.def_chan_for_reminder =
        additionallyStore.def_chan_for_reminder == ''
        ? additionallyStore.getFirstChannelId
        : additionallyStore.def_chan_for_reminder;
    });

    return {
      additionallyStore,
      channelStore
    }
  },

  template: /*html*/`
    <div class="additionally-def_chan_for_reminder">
      <div>
        <span>{{ $t('default_channel_for_reminders') }}</span>
        <span
          h_id="wazzup_default_channel_for_reminders"
          class="help_bt"
        ></span>
        <span>:</span>
      </div>

      <div>
        <select
          class="form-control"
          v-model="additionallyStore.def_chan_for_reminder"
        >
          <template
            v-for="channel in channelStore.channels"
            :key="channel.channel_id"
          >
            <option
              v-if="channel.transport == 'whatsapp' || channel.transport == 'tgapi' || channel.transport == 'max'"
              :value="channel.channel_id"
            >{{ channel.channel_name || channel.channel_id }}</option>
          </template>
        </select>
      </div>
    </div>
  `
}
