import useAdditionallyTabWazzupExtensionStore from '../../store/useAdditionallyTabWazzupExtensionStore.js';

export const DeleteMessage = {
  name: 'delete_days',

  setup(props, {emit}) {
    const additionallyStore = useAdditionallyTabWazzupExtensionStore();

    Vue.onMounted(() => {
      checkHelpButtonsOnCurrentPage();
      bind_help_bt('wazzup');
    });

    return {
      additionallyStore,

      validateMinimumValue(value) {
        if (Number(value) <= 0) {
          additionallyStore.wazzup_delete_days = '';
        }
      }
    }
  },

  template: /*html*/`
    <div class="additionally-def_chan_for_reminder">
      <div>
        <span>{{ $t('delete_days') }}</span>
        <span
          h_id="wazzup_delete_days"
          class="help_bt"
        ></span>
        
        <span>:</span>
      </div>
      <div>
        <input
          type="number"
          :min="1"
          class="form-control"
          style="width: 100px; box-sizing: border-box;"
          v-model="additionallyStore.delete_days"
          @blur="validateMinimumValue(additionallyStore.delete_days)"
        /> дней
      </div>
    </div>
  `
}
