import useScopedStyleMixin from '../../useScopedStyleMixin.js';
import CheckboxStyles from './CheckboxStyles.js';

const isEmpty = (v) => v === undefined || v === null || v === '' || v === '[]';

const Checkbox = {
  name: 'checkbox',
  props: {
    storeFieldId: String,
    dataSource: Object,
    fieldsSource: Object,
    dataValue: String,
    options: Object,
    required: String
  },
  data() {
    return { componentClass: 'checkbox' }
  },
  mixins: [useScopedStyleMixin, CheckboxStyles],

  computed: {
    hasOptions() {
      // Есть options или optionsFrom
      return this.options && Object.keys(this.options).length > 0 || 
             this.fieldsSource[this.storeFieldId]?.optionsFrom;
    },
    
    isEmptyOptions() {
      // options пустой, но есть optionsFrom.empty
      return (!this.options || Object.keys(this.options).length === 0) && 
             this.fieldsSource[this.storeFieldId]?.optionsFrom?.empty;
    },
    
    shouldShowSingleCheckbox() {
      // Не определено options, и нет optionsFrom
      return (!this.options || Object.keys(this.options).length === 0) && 
             !this.fieldsSource[this.storeFieldId]?.optionsFrom;
    },
    
    currentOptions() {
      // Возвращаем options или пустой объект если options нет
      return this.options || {};
    },
    
    isChecked() {
      // Для одиночного чекбокса
      return Boolean(this.dataSource[this.storeFieldId]);
    }
  },

  methods: {
    isOptionChecked(value) {
      console.log("isOptionChecked on " + value + ": ", this.dataSource[this.storeFieldId]);
      // Проверяем, есть ли значение в массиве dataSource[storeFieldId]
      if (!Array.isArray(this.dataSource[this.storeFieldId])) {
        console.log(`[Checkbox] dataSource[${this.storeFieldId}] is not an array`);
        return false;
      }
      
      return this.dataSource[this.storeFieldId].includes(value);
    },
    
    updateSingleCheckbox(value) {
      // Обновляем значение одиночного чекбокса
      this.$set(this.dataSource, this.storeFieldId, value);
    },
    
    updateArrayCheckbox(value, checked) {
      // Обновляем массив значений для группы чекбоксов
      if (!Array.isArray(this.dataSource[this.storeFieldId])) {
        this.$set(this.dataSource, this.storeFieldId, []);
      }
      
      const currentArray = this.dataSource[this.storeFieldId];
      if (checked) {
        // Добавляем значение если его нет
        if (!currentArray.includes(value)) {
          currentArray.push(value);
        }
      } else {
        // Удаляем значение
        const index = currentArray.indexOf(value);
        if (index > -1) {
          currentArray.splice(index, 1);
        }
      }
    }
  },

  template: /*html*/`
    <div :class="componentClass + hash">
      <!-- Случай 1: Есть options или optionsFrom -->
      <template v-if="hasOptions">
        <!-- Случай 2: options пустой, но есть optionsFrom.empty -->
        <div v-if="isEmptyOptions" :class="componentClass + '__empty' + hash">
          {{ $t(fieldsSource[storeFieldId].optionsFrom.empty) }}
        </div>
        
        <!-- Случай 1: Выводим список чекбоксов -->
        <label
          v-else
          v-for="(option, value) in currentOptions"
          :key="value"
          :class="componentClass + '__label' + hash"
        >
          <input 
            type="checkbox" 
            :value="value"
            :checked="isOptionChecked(value)"
            @change="updateArrayCheckbox(value, $event.target.checked)"
          /> 
          {{ option }}
        </label>
      </template>
      
      <!-- Случай 3: Не определено options, и нет optionsFrom - один чекбокс -->
      <label v-else-if="shouldShowSingleCheckbox" :class="componentClass + '__label' + hash">
        <input 
          type="checkbox" 
          :required="required" 
          :checked="isChecked"
          v-model="dataSource[storeFieldId]" 
        />
      </label>
      
      <!-- Резервный вариант -->
      <label v-else :class="componentClass + '__label' + hash">
        <input 
          type="checkbox" 
          :required="required" 
          :checked="isChecked"
          v-model="dataSource[storeFieldId]" 
        />
      </label>
    </div>
  `
};

export default Checkbox;