/**
 * Модуль сохранения данных приложения в localStorage
 */

const WALL_STORAGE_KEY = "cb_wall_storage";

const persist = {
    getData() {
        const items = JSON.parse(localStorage.getItem(WALL_STORAGE_KEY) || "[]");
        return items;
    },
    putData(items) {
        localStorage.setItem(WALL_STORAGE_KEY, JSON.stringify(items));
    },
}

export { persist };
