import useTranslate from "../../hooks/useTranslate.js";

/**
 * bookmark-svg-icon
 */
export default Vue.defineCustomElement({
  props: {
    switch: String,
  },

  setup(props, {emit}) {
    return {
      setStyle() {
        return props.switch == 'on' ? '' : 'opacity: 0.6; filter: var(--svg-filter-for-settings-icon);';
      },

      setFill() {
        let color = getComputedStyle(document.body).getPropertyValue('--cur-scheme-color-7');
        return props.switch == 'on' ? (
          color == '' ? '#feda4e' : 'var(--cur-scheme-color-7)'
        ) : '#c1c1c1';
      },

      setTitle() {
        return props.switch == 'on' ? useTranslate('Remove_from_favorites') : useTranslate('Add_to_favorites');
      }
    }
  },

  template: /*html*/`
    <div :title="setTitle()">
      <svg
        :style="setStyle()"
        viewBox="0 0 25 25" fill="none" xmlns="http://www.w3.org/2000/svg"
      >
        <g clip-path="url(#clip0_152_5)">
          <path
            :fill="setFill()"
            d="M17.5566 1.96411H6.88997C6.53635 1.96411 6.19721 2.10459 5.94717 2.35464C5.69712 2.60468 5.55664 2.94382 5.55664 3.29744V21.9174C5.55643 22.1817 5.63475 22.4401 5.78166 22.6597C5.92857 22.8794 6.13745 23.0505 6.38176 23.1512C6.62608 23.2519 6.89482 23.2778 7.15385 23.2255C7.41289 23.1732 7.65055 23.0451 7.83664 22.8574L12.1966 18.5108L16.6166 22.9108C16.8035 23.0965 17.0412 23.2227 17.2997 23.2735C17.5582 23.3243 17.826 23.2973 18.0692 23.196C18.3124 23.0948 18.5202 22.9237 18.6663 22.7044C18.8123 22.4852 18.8902 22.2276 18.89 21.9641V3.29744C18.89 2.94382 18.7495 2.60468 18.4994 2.35464C18.2494 2.10459 17.9103 1.96411 17.5566 1.96411Z"
          />
        </g>

        <defs>
          <clipPath id="clip0_152_5">
            <rect width="24" height="24" fill="white" transform="translate(0.223145 0.630859)"/>
          </clipPath>
        </defs>
      </svg>
    </div>
  `,

  styles: [/*css*/`
    svg:hover {
      opacity: 1 !important;
    }
  `],
});
