import useTranslate from "../../hooks/useTranslate.js";

/**
 * resize-svg-icon
 */
export default Vue.defineCustomElement({
  props: {
    switch: String,
  },

  setup(props, {emit}) {
    return {
      setStyle() {
        return props.switch == 'on' ? '' : 'opacity: 0.6; filter: var(--svg-filter-for-settings-icon);';
      },

      setFill() {
        let color = getComputedStyle(document.body).getPropertyValue('--cur-scheme-color-7');
        return props.switch == 'on' ? (
          color == '' ? '#feda4e' : 'var(--cur-scheme-color-7)'
        ) : '#c1c1c1';
      },

      setTitle() {
        return props.switch == 'on' ? useTranslate('Turn_off_preview_mode') : useTranslate('Enable_preview_mode');
      }
    }
  },

  template: /*html*/`
    <div :title="setTitle()">
      <svg
        :style="setStyle()"
        viewBox="0 0 25 24" fill="none" xmlns="http://www.w3.org/2000/svg"
      >
        <g clip-path="url(#clip0_148_82)">
          <path
            :fill="setFill()"
            d="M21.2121 0.89947C20.9192 0.606577 20.4443 0.606577 20.1514 0.899471L16.4612 4.5897C16.1683 4.88263 15.6933 4.88259 15.4004 4.58963L13.7208 2.90952C13.2484 2.43694 12.4404 2.77154 12.4404 3.43977V11.3095C12.4404 11.7238 12.7762 12.0595 13.1904 12.0595H21.0602C21.7284 12.0595 22.063 11.2516 21.5904 10.7791L19.9103 9.09947C19.6173 8.80658 19.6173 8.33165 19.9102 8.03873L23.6004 4.3485C23.8933 4.05561 23.8933 3.58073 23.6004 3.28784L21.2121 0.89947ZM3.57063 12.3095C2.9024 12.3095 2.5678 13.1175 3.04038 13.5899L4.72049 15.2696C5.01345 15.5625 5.01348 16.0374 4.72056 16.3303L1.03033 20.0206C0.737436 20.3134 0.737437 20.7883 1.03033 21.0812L3.4187 23.4696C3.71159 23.7625 4.18647 23.7625 4.47936 23.4696L8.16959 19.7793C8.46251 19.4864 8.93744 19.4865 9.23032 19.7794L10.91 21.4595C11.3824 21.9321 12.1904 21.5975 12.1904 20.9293V13.0595C12.1904 12.6453 11.8546 12.3095 11.4404 12.3095H3.57063Z"
          />
        </g>

        <defs>
          <clipPath id="clip0_148_82">
            <rect width="23.6308" height="23.6308" fill="white" transform="translate(0.5 0.369141)"/>
          </clipPath>
        </defs>
      </svg>
    </div>
  `,

  styles: [/*css*/`
    svg:hover {
      opacity: 1 !important;
    }
  `],
});
