/** 
 * cb-hello - компонент-приветствие
 * 
 * ```
 * <cb-hello name=""></cb-hello>
 * ```
 * 
 *  Выводит строку вида "Hello, {name}"
 * 
 */

const styles = [
/*css*/`
.cb-hello {
    color: darkred;
    font-weight: bold;
}
`,
];

const template = /*html*/`
<span class="cb-hello">
    Hello, {{name}}
</span>
`;

export default Vue.defineCustomElement({
    template,
    styles,
    props: {
        name: String,
    },
    setup(props) {
        const name = Vue.toRef(props,'name');
        return {
            name,
        }
    },
})
