'use strict';

import { getLang } from "../../lang.js";

export function CallButton(options) {
  return {
    data () {
      return {
        lang: getLang(config["lang"] == "russian" ? config["lang"] : "english"),
      }
    },

    computed: {
      getImgSrc() {
        return `./stocks/telephony/images/tel.png`;
      }
    },

    methods: {
      handleClick() {
        if (!this.getStoreValue('user_status').status) {
          jalert(this.getStoreValue('user_status').message);
          return;
        } else if (
          this.getStoreValue('provider_settings').sip_login.trim() == '' ||
          this.getStoreValue('provider_settings').sip_password.trim() == ''
        ) {
          jalert(this.lang.You_are_not_authorized);
          return;
        }

        let is_showed_call_block = this.getStoreValue('is_showed_call_block');
        this.setStoreValue('is_showed_call_block', !is_showed_call_block);

        if (
          !this.getStoreValue('is_showed_call_block') &&
          (this.getStoreValue('Call') &&
          !(!!this.getStoreValue('Call').isCall))
        ) {
          //store.set('phone_number', '');
          this.setStoreValue('service_text', '');
        }

        if (this.getStoreValue('phone_number') != '') {
          let Call = this.getStoreValue('Call') || {};
          Call['numberForCall'] = this.getStoreValue('phone_number');
          this.setStoreValue('Call', Call);
        }
        // if(!is_showed_call_block){
        //     document.getElementById('call_block-tel_number').focus();
        // }
      }
    },

    template: `
      <button class="header__user-item" @click=handleClick>
        <img :src="getImgSrc" alt="tel" style="width: 16px;height: 16px;cursor: pointer; filter: invert(1);" />
      </button>
    `
  }
}
