'use strict';

import { Input } from '../common/input.js';
import { Button } from '../common/button.js';
import { Numpad } from './Numpad.js';
import { CallNotification } from './CallNotification.js';
import { getLang } from '../../lang.js';

export function CallBlock(_store, component_path, cbext){
    let l = getLang(config["lang"] == "russian" ? config["lang"] : "english");
    let store = _store;
    let callBlockPosition = JSON.parse(localStorage.getItem('callBlockPosition')) || {left: '1433px', top: '545px'}

    $(`#call-block__${cbext}`).draggable({
        handle: ".call-content",
        stop: function () {
            let top = $(`#call-block__${cbext}`).css("top"),
                left = $(`#call-block__${cbext}`).css("left")
            localStorage.setItem("callBlockPosition", JSON.stringify({top,left}))
        }
    });

    $(`#call-block__${cbext}`).css({'left': callBlockPosition.left, 'top': callBlockPosition.top})

    return {
        view: function(){
            return store.get('is_showed_call_block') ? m('div', {
                class: 'call-content'
            }, [
                store.get('show_addition') ? m('div', {style: (store.get('Call').isCall) ? 'display:flex;justify-content: space-evenly;' : 'display:flex;'}, [
                    (store.get('Call') && !(store.get('Call').isCall)) ||
                    !store.get('Call')
                        ? m('button', {
                            class: 'call_block--btn call_block--btn-cost',
                            onclick: async () => {
                                if(store.get('service_text').length != 0){
                                    store.set('service_text', '');
                                    return;
                                }
                                if(trim(store.get('phone_number')).length == 0){
                                    store.set('service_text', l.Number_is_empty + '!');
                                    setTimeout(() => {
                                        store.set('service_text', '');
                                    }, 5000);
                                    return;
                                }
                                store.set('cost_button_text', '...');
                                let req = store.get('req');
                                req['phonenumber'] = store.get('phone_number');
                                store.set('req', req);
                                let result = await store.get('scall')(store.get('params'), 'getPriceByDirection2', store.get('req'), 'json'); // Выгрузка за период
                                if(result.error_message && result.error_message != ''){
                                    store.set('service_text', result.error_message);
                                } else if(result.data['price']){
                                    store.set('service_text', `Cost per minute - ${result.data['price']} ${result.data['currency']}`);
                                }
                                store.set('cost_button_text', 'Стоимость');
                            }
                        }, store.get('cost_button_text') == 'Стоимость' || store.get('cost_button_text') == void 0
                            ? m('img', {
                                style: 'width: 19px; height: 19px;',
                                src: `./${component_path}/images/coins.svg`,
                                alt: 'Cost'
                            })
                            : store.get('cost_button_text')
                        )
                        : null,
                    (store.get('Call') && store.get('Call').isCall)
                        ? m(Button, {
                            class: 'call_block--btn  call_block--btn-redirect',
                            onclick: (e) => {
                                e.preventDefault();
                                store.set('show_redirect_block', !store.get('show_redirect_block'));
                                localStorage.setItem('startReferCall', JSON.stringify({data: store.get('show_redirect_block')}))
                            }
                        }, m('img', {
                                src: `./${component_path}/images/call-forwarding.png`,
                                width: '19px',
                                heigth: '19px'
                            }))
                        : null,
                    (store.get('Call') && store.get('Call').isCall) ?
                        m('button', {
                            class: 'call_block--btn call_block--btn-mute',
                            style: store.get('mute') ? 'border-radius: 50%;background: #b1b0b0;' : '',
                            onclick: (e) => {
                                e.preventDefault();
                                store.set('mute', !store.get('mute'))
                                localStorage.setItem('muteCall', JSON.stringify({data: store.get('mute')}))
                            }
                        }, m('img', {
                            src: `./${component_path}/images/mute.png`,
                            width: '19px',
                            heigth: '19px'
                        })) : null,
                    (store.get('Call') && store.get('Call').isCall) ?
                        m('button', {
                            class: 'call_block--btn call_block--btn-pause',
                            style: store.get('pause') ? 'border-radius: 50%;background: #b1b0b0;' : '',
                            onclick: (e) => {
                                e.preventDefault();
                                store.set('pause', !store.get('pause'))
                                localStorage.setItem('holdCall', JSON.stringify({data: store.get('pause')}))
                            }
                        }, m('img', {
                            src: `./${component_path}/images/pause.png`,
                            width: '19px',
                            heigth: '19px'
                        })) : null
                ]) : null,
                m('button', {
                    class: 'call_notification--header-close',
                    onclick: () => {
                        store.set('is_showed_call_block', false);
                        //store.set('phone_number', '');
                        store.set('service_text', '');
                    }
                }),
                m('div', {
                    class: ''
                }, [
                    m('div', {
                        style: 'display:flex;'
                    }, [
                        m(Input, {
                            id: 'call_block-tel_number',
                            type: 'text',
                            icon: {
                                src: `./${component_path}/images/tel.png`,
                                alt: 'tel'
                            },
                            class: 'call_block-tel',
                            placeholder: 'Enter the number',
                            value: store.get('phone_number'),
                            disabled: store.get('is_call'),
                            oninput: function(e) {

                                store.set('phone_number', this.value.replace(/[^\d\+\#\*]/g, ''));
                            },
                            onkeydown: function(e) {
                                if(e.keyCode == 13){
                                    store.get('call')();
                                }
                                if ( e.keyCode == 46 || e.keyCode == 8 || e.keyCode == 9 || e.keyCode == 27 ||
                                    (e.keyCode == 65 && e.ctrlKey === true) ||
                                    (e.keyCode == 67 && e.ctrlKey === true) ||
                                    (e.keyCode == 86 && e.ctrlKey === true) ||
                                    (e.keyCode == 88 && e.ctrlKey === true) ||
                                    (e.keyCode >= 35 && e.keyCode <= 39)
                                ) {
                                    return;
                                } else {
                                    // Запрещаем все, кроме цифр на основной клавиатуре, а так же Num-клавиатуре
                                    if ((e.keyCode < 48 || e.keyCode > 57) && (e.keyCode < 96 || e.keyCode > 105 )) {
                                        e.preventDefault();
                                    }
                                }
                            }
                        }),
                        m('div', {
                            class: 'call_block-buttons_block'
                        }, [
                            (store.get('Call') && !store.get('Call').isCall || !!!store.get('Call'))
                                ? m(Button, {
                                    class: 'call_block--btn call_block--btn-call',
                                    onclick: () => {
                                        localStorage.setItem('goCall', JSON.stringify({data:true}))
                                    },
                                }, 'Call')
                                : null,
                            (
                                store.get('Call') && store.get('Call').isCall && !!!store.get('is_call') &&
                                store.get('call_type') == 'incoming'
                            )
                                ? m(Button, {
                                    class: 'call_block--btn call_block--btn-answer',
                                    onclick: store.get('callAnswer')
                                }, 'Answer')
                                : null,
                            (store.get('Call') && store.get('Call').isCall)
                                ? m(Button, {
                                    class: 'call_block--btn  call_block--btn-reject',
                                    style: 'width: 100%',
                                    onclick: store.get('call_type') == 'incoming' ? store.get('incomingHangUp') : store.get('hangUp'),
                                }, 'Reject')
                                : null,
                            (store.get('Call') && store.get('Call').isCall) &&
                            store.get('call_type') == 'outgoing'
                                ? m('div', { style: 'width: 35%;' })
                                : null,
                                m('button', {
                                    class: 'call_block--btn call_block--btn-numpad',
                                    onclick: (e) => {
                                        e.preventDefault();
                                        if(!store.has('show_number_block')){
                                            store.set('show_number_block', true);
                                        }
                                        else {
                                            store.set('show_number_block', !store.get('show_number_block'));
                                        }
                                    }
                                }, m('img', {
                                    src: `./${component_path}/images/keypad.svg`
                                })),
                                m('button', {
                                    class: 'call_block--btn call_block--btn-numpad',
                                    onclick: (e) => {
                                        e.preventDefault();
                                        if(!store.has('show_addition')){
                                            store.set('show_addition', true);
                                        }
                                        else {
                                            store.set('show_addition', !store.get('show_addition'));
                                        }
                                    }
                                }, m('img', {
                                    src: `./${component_path}/images/dots.png`,
                                    width: '16px',
                                    heigth: '16px'
                                }))
                        ])
                    ]),
                    m('div', {
                        style: 'width: 253px;'
                    }, store.get('service_text') || ''),
                    store.get('show_redirect_block')
                        ? m('div', {
                            class: 'call_block-forward'
                        }, [
                            m('select', {
                                onchange: function(){
                                    localStorage.setItem('redirect_number', this.value);
                                }
                            }, [{ id: 0, name: '', short_number: '' }, ...store.get('users_info')].map(item => m('option', {
                                value: item.short_number,
                            }, item.name))),
                            m('button', {
                                class: '.call_block--btn',
                                onclick: (e) => {
                                    e.preventDefault()
                                    localStorage.setItem('forwardCall', JSON.stringify({data:true}))
                                }
                            }, m('img', {
                                src: `./${component_path}/images/call-forwarding.png`
                            }))
                        ])
                        : null,
                    store.has('show_number_block') &&
                    store.get('show_number_block')
                        ? m(Numpad, { store })
                        : m('div', { style: 'width: 15%' }),
                    m(CallNotification, { store })
                ])
            ]) : null;
        }
    }
}
