{include file="./index_top.tpl"}
<script language="JavaScript" type="text/javascript">
    // значения для системной подсказки
    var help_section = 'Settings';
    var help_sub_section = 'Additional';

    function change_interval(select_obj) {
        var val = select_obj.options[select_obj.selectedIndex].value;
        if (val == "advanced") document.getElementById('period_advanced').style.display = "block";
        else document.getElementById('period_advanced').style.display = "none";
        var r_obj = document.getElementById('period_val');
        if (val == "every_minute")        r_obj.value = "* * * * *";
        if (val == "every_5_minute")      r_obj.value = "1-59/5 * * * *";
        if (val == "every_15_minute")     r_obj.value = "1,15,30,45 * * * *";
        if (val == "every_hour")          r_obj.value = "1 * * * *";
        if (val == "every_day_3_oclock")  r_obj.value = "1 3 * * *";
        if (val == "every_day_12_oclock") r_obj.value = "1 12 * * *";
        if (val == "every_day_23_oclock") r_obj.value = "1 23 * * *";
    }
    ;
    var history_window;


    function doPopup(popupPath) {
        window.open(popupPath, 'name', 'width=500,height=400,scrollbars=YES');
    }

    //cron period validation
    function editPeriod() {
        document.querySelector('#period_val').style.backgroundColor = '';
        document.querySelector('#period_val').form.elements.save[1].removeAttribute("disabled");
    }

    function checkPeriod() {
        let period = document.getElementById('period_val');
        let chunks = period.value.split(' ');
        let value_for_input = '';
        if(chunks.length > 5 || chunks.length < 5){
            period.style.backgroundColor = '#faa7a7';
            document.querySelector('#period_val').form.elements.save[1].setAttribute("disabled", "true");
        }
        else {
            let conformity = 0;
            for(let [i, value] of chunks.entries()){
                if(i == 0){
                    if(checkCronVar(value, 0, 59, 2)){
                        conformity++;
                    }
                }
                else if(i == 1){
                    if(checkCronVar(value, 0, 23, 2)){
                        conformity++;
                    }
                }
                else if(i == 2){
                    if(checkCronVar(value, 1, 31, 2)){
                        conformity++;
                    }
                }
                else if(i == 3){
                    let months = ['Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun', 'Jul', 'Aug', 'Sep', 'Oct', 'Nov', 'Dec'];
                    for(const [index, month] of months.entries()){
                        value = value.replace(new RegExp(month, 'g'), index + 1);
                    }
                    if(checkCronVar(value, 1, 12, 2)){
                        conformity++;
                    }
                }
                else {
                    let days = ['Mon', 'Tue', 'Wed', 'Thu', 'Fri', 'Sat', 'Sun'];
                    for(const [index, day] of days.entries()){
                        value = value.replace(new RegExp(day, 'g'), index + 1);
                    }
                    if(checkCronVar(value, 1, 7, 1)){
                        conformity++;
                    }
                }
                value_for_input += i == chunks.length - 1 ? value : value + ' ';
            }
            if(conformity < 5){
                period.style.backgroundColor = '#faa7a7';
                document.querySelector('#period_val').form.elements.save[1].setAttribute("disabled", "true");
            }
            else {
                period.value = value_for_input;
            }
        }
    }

    function isRange(value, start, end){
        let chunks = value.split("-");
        if(chunks.length == 2 && chunks[0] >= start && chunks[1] <= end && (isFinite(chunks[0]) && isFinite(chunks[1]) && chunks[0] < chunks[1])){
            return true;
        }
        else {
            return false;
        }
    }

    function checkCronVar(variable, start, end, lenVar) {
        let len = variable.length;
        if(len > lenVar){
            let chunksSlash = variable.split("/");
            let chunksComma = variable.split(",");
            let chunksMinus = variable.split("-");
            if(chunksSlash.length == 2){
                if((isRange(chunksSlash[0], start, end) || chunksSlash[0] == '*') && chunksSlash[1] >= start && chunksSlash[1] <= end){
                    return true;
                } 
                return false;
            }
            else if(chunksComma.length > 1){
                let conformity = 0;
                for(const chunk of chunksComma){
                    if(chunk == '*' || isFinite(chunk) && (chunk >= start && chunk <= end)){
                        conformity++;
                        continue;
                    }
                    return false;
                }
                if(conformity == chunksComma.length) {
                    return true;
                }
                else {
                    return false;
                }
            }
            else if(chunksMinus.length == 2 && isRange(variable, start, end)){
                return true;
            }
            else {
                return false;
            }
        }
        else {
            if(variable == '*' || isFinite(variable) && (variable >= start && variable <= end)){
                return true;
            }
            return false;
        }
    }

</script>
<div align=center>
    <br>{$lang.Cron_settings}<br><br>
    <form action="edit_cron.php?cron_id={$one_task.id}" method="post" enctype="multipart/form-data">
        <table border=0 cellpadding=3>
            {if $message}
                <tr>
                    <td align=center colspan=2 style="color:green;padding-bottom:15px">{$message}</td>
                </tr>
            {/if}
            <tr>
                <td align=right>{$lang.Description}<span class='help_bt' h_id='Description'></span>:</td>
                <td><input class="form-control form-control-160" type=text name='description' value="{$one_task.description}" size=35></td>
            </tr>
            {if ($user.group_id == 1 || $user.sub_admin_rights.edit_php) && !$one_task.system}
                {if $one_task.calc_id}
                <tr>
                    <td align=right>{$lang.Calc}<span class='help_bt' h_id='Cron_calc'></span>:</td>
                    <td>
                        <a href="edit_calc.php?calc_id={$one_task.calc_id}" target="_blank">{$lang.Open}</a>
                    </td>
                </tr>
                {else}
                <tr>
                    <td align=right>{$lang.Command}<span class='help_bt' h_id='Command'></span>:</td>
                    <td>
                        {if $one_task.command|strlen < "50"}
                            <textarea class="form-control" name='command'>{$one_task.command}</textarea>
                        {else}
                            <a href="#"
                               onclick="open_calc('cron_id={$one_task.id}&part=cron_php',{$one_task.command|strlen});return false;">{$lang.Edit}</a>
                        {/if}
                    </td>
                </tr>
                {/if}
            {/if}
            <tr>
                <td align=right>{$lang.Period}<span class='help_bt' h_id='Period'></span>:</td>
                <td>
                    <select class="form-control form-control-160" onchange="change_interval(this)">
                        <option value="every_minute"
                                {if $one_task.period eq "* * * * *"}selected{/if}>{$lang.Every_minute}</option>
                        <option value="every_5_minute"
                                {if $one_task.period eq "1-59/5 * * * *"}selected{/if}>{$lang.Every_5_minute}</option>
                        <option value="every_15_minute"
                                {if $one_task.period eq "1,15,30,45 * * * *"}selected{/if}>{$lang.Every_15_minute}</option>
                        <option value="every_hour"
                                {if $one_task.period eq "1 * * * *"}selected{/if}>{$lang.Every_hour}</option>
                        <option value="every_day_3_oclock"
                                {if $one_task.period eq "1 3 * * *"}selected{/if}>{$lang.Every_day_3_oclock}</option>
                        <option value="every_day_12_oclock"
                                {if $one_task.period eq "1 12 * * *"}selected{/if}>{$lang.Every_day_12_oclock}</option>
                        <option value="every_day_23_oclock"
                                {if $one_task.period eq "1 23 * * *"}selected{/if}>{$lang.Every_day_23_oclock}</option>
                        <option value="advanced"
                                {if $one_task.period neq "* * * * *" and $one_task.period neq "1-59/5 * * * *" and $one_task.period neq "1,15,30,45 * * * *" and $one_task.period neq "1 * * * *" and $one_task.period neq "1 3 * * *" and $one_task.period neq "1 12 * * *" and $one_task.period neq "1 23 * * *"}
                        selected
                                {/if}>{$lang.Advanced}</option>
                    </select>
                    <div id="period_advanced"
                            {if $one_task.period neq "* * * * *" and $one_task.period neq "1-59/5 * * * *" and $one_task.period neq "1,15,30,45 * * * *" and $one_task.period neq "1 * * * *" and $one_task.period neq "1 3 * * *" and $one_task.period neq "1 12 * * *" and $one_task.period neq "1 23 * * *"}
                            {else}
                                style="display:none"
                            {/if}
                    >
                        {$lang.Enter_cron_interval}
                        <br>
                        <input class="form-control form-control-160" type=text id="period_val" name='period' value="{$one_task.period}" onblur="checkPeriod()" onfocus="editPeriod()">
                    </div>
                </td>
            </tr>
            <tr>
                <td align=right>{$lang.Thread}<span class='help_bt' h_id='Thread'></span>:</td>
                <td><input class="form-control form-control-160" type=text name='thread_name' value="{$one_task.thread_name}"></td>
            </tr>
            <tr>
                <td align=right>{$lang.Last_start_time}<span class='help_bt' h_id='Last_start_time'></span>:</td>
                <td>{$one_task.last_start_time}</td>
            </tr>
            <tr>
                <td align=right>{$lang.Last_stop_time}<span class='help_bt' h_id='Last_stop_time'></span>:</td>
                <td>{$one_task.last_stop_time}</td>
            </tr>
            <tr>
                <td align=right>{$lang.Operating_time}:</td>
                <td>{$one_task.operating_time}</td>
            </tr>
            <tr>
                <td align=right>{$lang.Status}<span class='help_bt' h_id='Status'></span>:</td>
                <td>{if $one_task.run_status}{$lang.Running}{else}{$lang.Stopped}{/if}</td>
            </tr>
            <tr>
                <td align=right>{$lang.Disable_cron}<span class='help_bt' h_id='Disable_cron'></span>:</td>
                <td><input type="checkbox" name="disabled_cron" {if $one_task.disabled}checked{/if}></td>
            </tr>
            <tr>
                <td align=right>{$lang.One_time_start}<span class='help_bt' h_id='One_time_start'></span>:</td>
                <td><input type="checkbox" name="one_time" {if $one_task.one_time}checked{/if}></td>
            </tr>
            <tr>
                <td align=right>{$lang.Max_exec_time}<span class='help_bt' h_id='Max_exec_time'></span>:</td>
                <td><input class="form-control form-control-160" type=text name='max_exec_time'
                           value="{if $one_task.max_exec_time}{$one_task.max_exec_time}{/if}"
                           style="width:50px;text-align:right;"> {$lang.minutes}<br></td>
            </tr>
            <tr>
                <td align=right>{$lang.max_system_exec_time}<span class='help_bt' h_id='max_system_exec_time'></span>:
                </td>
                <td>{$max_system_exec_time} {$lang.minutes}</td>
            </tr>
            <tr>
                <td align=right>{$lang.check_task_status}<span class='help_bt' h_id='check_task_status'></span>:</td>
                <td><input type="checkbox" name="check_enabled" {if $one_task.check_enabled}checked{/if}
                           onclick="$('.check_task_options').toggle()">
                </td>
            </tr>
            <tr {if !$one_task.check_enabled}style="display:none"{/if} class="check_task_options">
                <td align=right>{$lang.task_output_result}<span class='help_bt' h_id='task_output_result'></span>:</td>
                <td><select class="form-control form-control-160" name='check_cond'>
                        <option value=''></option>
                        <option value='=' {if $one_task.check_cond == '='}selected{/if}>{$lang['=']}</option>
                        <option value='like' {if $one_task.check_cond == 'like'}selected{/if}>{$lang['LIKE']}</option>
                        <option value='not like'
                                {if $one_task.check_cond == 'not like'}selected{/if}>{$lang['NOT LIKE']}</option>
                    </select> <input class="form-control form-control-160" type=text name='check_text' value='{$one_task.check_text}'></td>
            </tr>
            <tr {if !$one_task.check_enabled}style="display:none"{/if} class="check_task_options">
                <td></td>
                <td>
                    <input type="checkbox" name="check_notify" {if $one_task.check_notify}checked{/if}> {$lang.popup_notify}<br>
                    <input type="checkbox" name="check_email" {if $one_task.check_email}checked{/if}> {$lang.email_notify}
                </td>
            </tr>
            <tr>
                <td align=right>{$lang.Log}<span class='help_bt' h_id='Log'></span>:</td>
                <td><a href="#"
                       onclick="var left = ( screen.width - 755 ) / 2; var top = ( screen.height - 500 ) / 2; if ((history_window)&&(!history_window.closed)) history_window.close(); history_window=window.open('edit_cron.php?sel=view_log&cron_id={$one_task.id}','ViewCronLog', 'top='+top+', left='+left+', menubar=0, resizable=1, scrollbars=1, status=0, toolbar=0, width=750, height=450');return false;">{$lang.View} {$one_task.log_lines} {$lang.lines}</a>
            </tr>
            <tr>
                <td align=right></td>
                <td><input type=checkbox name=clear_log>{$lang.clear_log}</td>
            </tr>
            <tr>
                <td align=right>{$lang.Help}<span class='help_bt' h_id='Help'></span>:</td>
                <td>
                    <textarea class="form-control" name="help">{$one_task.help}</textarea>
                </td>
            </tr>
            {if $one_task.id > 0}
            <tr>
                <td align=right>{$lang.run_now}<span class='help_bt' h_id='run_now'></span>:</td>
                <td>
                    <input class="btn btn-default btn-sm" type=button
                           onclick="doPopup('edit_cron.php?sel=run_now&cron_id={$one_task.id}');return false"
                           value="{$lang.run_now}">
                </td>
            </tr>
            {/if}
        </table>
        <br>
        <input type=hidden value="{$csrf}" name="csrf">
        <input type=hidden value="{$base64_back_url}" name="back_url">
        <input class="btn btn-default btn-sm" type=submit value="{$lang.Save}" name="save">
        <br><br>
        <a href="edit_cron.php">{$lang.Return}</a>
    </form>
    <br>
</div>