import React, {useState, useEffect} from 'react';
import NormalizationJsonToExcel from './normalizationJsonToExcel';

// Компонент выгрузки данных отчета в Excel
export default ({exportData,title}) => {
    const [data, setData] = useState(exportData);
    const [fileName, setFileName] = useState('file_excel.xls');
    const [exportTableData, setExportData] = useState('');

    const prepareDataForExcel = layout => {
        const [tableCaption, tableHead, ...tableBody] = layout;
        const arrayDimension = Object.keys(tableHead).length;
        const caption = tableCaption.cell1 || 'Таблица';
        let resultHtmlForLayout = '';
        // Формируем заголовок таблицы
        resultHtmlForLayout += `<table cellspacing="0" cellpadding="3" border="1">\r\n<tr><td style="text-align: center" align="center" colspan="${arrayDimension}"><h1>${caption}</h1></td></tr>\r\n`;

        resultHtmlForLayout += '<tr>';
        // Формируем шапку таблицы
        for (let i in tableHead) {
            resultHtmlForLayout += `<td style="text-align: center;" align="center"><b>${tableHead[i]}</b></td>\r\n`;
        }
        resultHtmlForLayout += '</tr>';

        // Формируем тело таблицы
        let pos = 1;
        tableBody.forEach(bodyItem => {
            if (pos % 2) {
                resultHtmlForLayout += '<tr style="background-color: #d0d0d0;" bgcolor="#d0d0d0">';
            } else {
                resultHtmlForLayout += '<tr>';
            }

            for (let i in bodyItem) {
                resultHtmlForLayout += `<td style="text-align: center" align="center">${bodyItem[i]}</td>\r\n`;
            }
            pos += 1;
            resultHtmlForLayout += '</tr>';
        });

        resultHtmlForLayout += '</table>';
        resultHtmlForLayout += '<table><tr><td></td></tr></table>';
        return resultHtmlForLayout;
    };

    useEffect( () => {
        setData(exportData);
        // Создаем объект NDO (Normalization Data Object) для работы с классом-нормализатором
        const NDO = new NormalizationJsonToExcel(data);
        const outputFileName = NDO.getExcelFileName;
        const dataForExcel = NDO.normalizeData();
        /*const formatter = new FormatExcelData();
        const arrayOfColumnsWidth = formatter.formatData(dataForExcel);*/
        const htmlExcelData = dataForExcel.map(layout => prepareDataForExcel(layout));
        const exportExcelHtmlDataHead = "<html><head><meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\"></head><body>\r\n";
        const exportExcelHtmlDataFoot = "</body></html>";
        setFileName(`${outputFileName}.xls`);
        setExportData(exportExcelHtmlDataHead + htmlExcelData.toString() + exportExcelHtmlDataFoot);
    });

    const downloadFile = () => {
        /*
        // Создаем объект NDO (Normalization Data Object) для работы с классом-нормализатором
        const NDO = new NormalizationJsonToExcel(data);
        const outputFileName = NDO.getExcelFileName;
        const dataForExcel = NDO.normalizeData(); // Массив для выгрузки в каждый лист

        // Создаем книгу в экселе
        const wb = XLSX.utils.book_new();
        dataForExcel.forEach(dataList => {
            const { cell1 } = dataList[0]; // Извлекаем название элемента
            // Создаем лист в экселе
            let ws = XLSX.utils.json_to_sheet(dataList, {header:[], skipHeader:true, dateNF:'dd/mm/yyyy;@', cellDates:true, raw: true, cellStyles: true}); // параметр skipHeader скрывает хедеры по умолчанию (из ключей)
            const worksheetFormatter = new FormatExcelData(ws);
            ws = worksheetFormatter.formatData();
            if (!ws['!cols']) {
                ws['!cols'] = [];
            }
            ws['!cols'] = worksheetFormatter.fitToColumn(XLSX.utils.decode_range(ws['!ref'])); // Расчитываем ширину ячеек
            XLSX.utils.book_append_sheet(wb, ws, cell1);
        });

        // Генерируем XLSX файл
        XLSX.writeFile(wb, `${outputFileName}.xlsx`);*/
    };

    return (
      <a href={"data:application/vnd.ms-excel;charset=utf-8," + encodeURIComponent(exportTableData)} download={fileName} target="_blank">
          <img src="images/xsl.gif" style={{verticalAlign: 'bottom', border: 'none', marginRight: '3px'}}/>
    <button onClick={downloadFile}>{title}</button>
      </a>
    );
};