<?php
function calc_dig_expression($value) // вспомогательная функция
{
    global $lang;
    
    // приводим все числа в выражении к стандартному виду
    $value = str_replace($lang['space_delimiter'], "", $value);
    $value = str_replace($lang['float_delimiter'], ".", $value);
    if ($value === 'NAN' || $value === '' || $value === 'null') {
        return '';
    }
    // фильтруем, чтобы исключить возможность выполнения чужеродного кода
    $st0 = $value; $st1 = ''; $st2 = '';
    for ($i = 0, $iMax = strlen($st0); $i < $iMax; $i++) {
        if (((ord($st0[$i]) > 47) && (ord($st0[$i]) < 58)) || ($st0[$i] == '-') || ($st0[$i] == '+') || ($st0[$i] == '*') || ($st0[$i] == '/') || ($st0[$i] == '.') || ($st0[$i] == '(') || ($st0[$i] == ')')) {
            $st1 .= $st0[$i];
        }
    }

    // вычисляем выражение
    eval('
        global $st2;
        $st2=' . $st1 . ';
    ');
    
    return $st2;
}

function summa_propis($params)
{
    if (isset($params['value'])) {
        $value = $params['value'];
    } else {
        $value = $params['field'];
    }

    return num2str(calc_dig_expression($value), $params['currency'], $params['cents'], $params['caps'], $params['fem_currency'], $params['fem_cents'], $params['lang']);
}
$smarty->registerPlugin("function", "SumPropis", "summa_propis");

function summa_format($params)
{
    if (isset($params['value'])) {
        $value = $params['value'];
    } else {
        $value = $params['field'];
    }
    
    return number_format((float) calc_dig_expression($value), (int) $params['digits'], ',', $params['nospace'] ? '' : ' '); // использовать ли пробел в результате
}
$smarty->registerPlugin("function", "SumFormat", "summa_format");

function data_propis($params)
{
    return data2str(strtotime(form_eng_time($params['field'])), $params['format']);
}
$smarty->registerPlugin("function", "DataPropis", "data_propis");

function image_source($params)
{
    if ($params['field_id']) {
        foreach ($params as $key => $value) {
            $$key = $value;
        }

        $field = sql_select_array(FIELDS_TABLE, "id=", $field_id);
        $line = data_select_array($field['table_id'], "id=", $line_id);

        $fname = get_file_path($field['id'], $line_id, $line['f' . $field_id]);
        $content = file_get_contents($fname);
        list($w1, $h1) = getimagesize($fname);
        if ($width) {
            $w2 = $width;
            $h2 = $height;
        } else {
            $w2 = $w1;
            $h2 = $h1;
        }

        $cache_name = $field['table_id'] . "_" . $field['id'] . "_" . $line_id . "_" . utf2eng($line['f' . $field_id]) . "_" . intval($width) . "_" . intval($height) . "_" . intval($transparent) . ".png";
        if (!file_exists("cache/" . $cache_name)) {
            image_preview($content, $w1, $h1, $w2, $h2, $cache_name, $transparent);
        }
        $cache_content = file_get_contents("cache/" . $cache_name);

        if ($type_out == "html" or $type_out == "pdf") {
            return "cache/" . $cache_name;
        }
        if ($type_out == "embed") {
            return "data:image/png;base64," . base64_encode($cache_content);
        }
    } else {
        return substr($params['image'], 10, -2);
    }
}
$smarty->registerPlugin("function", "ImgSource", "image_source");