import View from '../view';
import {IFile, ILine} from './line';
import {TypeFields} from '../util';
import Access from '../access';

const drawNavBar = (): string => {
    const saveBtn: string = (Access.edit === 1) ?
        `<button type="button" id="edit-btn" class="nav-bar__btn nav-bar__btn--edit">Редактировать</button>` :
        ``;
    const deleteBtn: string = (Access.delete === 1) ?
        `<button type="button" id="delete-btn" class="nav-bar__btn nav-bar__btn--edit">Удалить</button>`:
        ``;
    return `<div class="nav-bar">
    ${saveBtn}
    ${deleteBtn}
    <button type="button" id="back-btn" class="nav-bar__btn nav-bar__btn--back">Вернуться в таблицу</button>
</div>`;
};

const drawLine = (data: Array<ILine>) => {
    let rows = ``;
    data.forEach((row: ILine) => {
        let valueField: string = ``;

        switch (row.type) {
            case TypeFields.IMAGE:
                if (typeof row.display_value === `object`) {
                    row.display_value.forEach((image: IFile) => {
                        valueField += `<a href="${image.src}" target="_blank">
    <img src="${image.src}" alt="${image.name}" width="100" height="100">
</a>`;
                    });
                }
                break;
            case TypeFields.FILE:
                if (typeof row.display_value === `object`) {
                    row.display_value.forEach((file: IFile) => {
                        valueField += `<a href="${file.src}" download>${file.name}</a>`;
                    });
                }
            default:
                if (typeof row.display_value === `string`) {
                    valueField = row.display_value;
                }
        }

        rows += `<div class="cb-view-line__row">
    <div class="cb-view-line__key">${row.name}</div>
    <div class="cb-view-line__val">${valueField}</div>
</div>`
    });

    return `<div class="cb-view-line">
    ${rows}
</div>
${drawNavBar()}`;
};

export default class LineView extends View {
    constructor(data: Array<ILine>) {
        super(data);
    }

    protected get template(): string {
        return drawLine(this.data);
    }
}