const fields = {    
    
      
    "apps": {

        "id": {
            "type": "input-text",
        },

        "name": {
            "type": "input-text",
            "default": "",
            //Указываем что это название элемента в списке, значение - префикс для названия (языковой идентификатор)
            "is_list_name": "app",
            "required": true,
            "help": "help_telegram_bot_app_name",
        },

        "auth_token": {
            "type": "input-text",
            "default": "",
            "required": true,
            "help": "help_telegram_bot_app_token",
        }
        
    },

    "connectors": {

        "name": {
            "type": "input-text",
            "default": "",
            "is_list_name": "connector",
            "required": true,
            "help": "help_telegram_bot_connector_name",
        },

        "external_app_id": {
            "type": "dropdown",
            "optionsFrom": {
                source: "list",
                field: "apps",
                value: "id",
                label: "name"
            },
            "required": true,
            "help": "help_telegram_bot_app",  
        },


        instant: {
            type: "dropdown",
            options: {
                0: "Отложенная обработка (по cron)",
                1: "Сразу после получения запроса",
            },
            default: 1,
            help: "help_telegram_bot_instance",
        },

        internal_object_id: {
            type: "dropdown",
            optionsFrom: {
                source: "tables",
            },
            required: true,
            help: "help_telegram_bot_object",
        },


         "external_action": {
            "type": "dropdown",
            "options": {
                "auto": "Автоматическое определение типа отправки",
                "send_message": "Отправить текст",
                "send_photo": "Отправить изображение+текст",
                "send_document": "Отправить документ+текст",
            },
            "required": true,
            "help": "help_telegram_bot_external_action"
        },      

        calc: {
            type: "html",
        },
    }

}

export default fields;