import useApiTabWazzupExtensionStore from './../../store/useApiTabWazzupExtensionStore.js';

export const WebhookBlock = {
  name: 'webhook-block',

  setup(props, {emit}) {
    const apiStore = useApiTabWazzupExtensionStore();

    Vue.onMounted(() => {
      checkHelpButtonsOnCurrentPage();
      bind_help_bt('wazzup');
    });

    return {
      apiStore
    }
  },

  template: /*html*/`
    <div class="wazzup__webhook_block">
      <span>Webhook url</span>
      <span h_id="wazzup_webhook_url" class="help_bt"></span>
      <span>:</span>

      <input
        disabled
        type="text"
        class="form-control"
        style="width: 44px; padding: 5px 5px;"
        value="https://"
      >
      <input
        type="text"
        class="form-control"
        :value="apiStore.webhook_uri"
        @input="apiStore.webhook_uri = $event.target.value"
      />
      <input
        disabled
        type="text"
        class="form-control"
        style="width: 115px; padding: 5px 2px;"
        value="/wazzup/webhook"
      >
    </div>
  `
}
