import useChannelsTabWazzupExtensionStore from './../../store/useChannelsTabWazzupExtensionStore.js';

export const ChannelsComponent = {
  name: 'channels-component',
  emits: ['saveHandle'],

  setup() {
    const channelStore = useChannelsTabWazzupExtensionStore();
    const channelId = Vue.ref('');
    const selected = Vue.ref('');

    Vue.onMounted(() => channelStore.getChannels());

    return {
      channelStore,
      channelId,
      setChannelId(id) {
        if (id != channelId.value) {
          selected.value = '';
        }
        channelId.value = channelId.value == id ? '' : id;
      },

      selected,
      setSelected: id => selected.value = selected.value == id ? "" : id,
    }
  },

  template: /*html*/`
    <div
      class="wazzup__channels_list"
      v-if="Object.keys(channelStore.channels).length > 0"
    >
      <template v-for="(channel, idx) in channelStore.channels">
        <div class="wazzup__channels_list__item">
          <delete-icon
            @handle="channelStore.deleteChannel(channel.channel_id)"
          ></delete-icon>
          <icon-component :transport="channel?.transport || ''" />
          <span
            v-if="channel.deleted"
            style="font-size: 16px; text-decoration: line-through; color: #bbb;"
          >{{ channel.channel_name || $t('no_name') }} ({{ channel.plain_id }})</span>

          <template v-else>
            <a
              style="cursor:pointer; font-size:16px; text-decoration: underline dotted;"
              @click="setChannelId(channel.channel_id)"
            >{{ channel.channel_name || $t('no_name') }} ({{ channel.plain_id }})</a>
            <div
              style="padding: 0 5px 0 12px; font-style: italic; color: #888;"
            >{{ channelStore.getChannelStatus(channel.channel_id) }}</div>
          </template>
        </div>
      </template>
    </div>

    <div v-else style="text-align: center;">
      <span>{{ $t('need_to_add_channels') }}</span>
    </div>

    <edit-channel
      v-if="channelId != ''"
      :channelId="channelId"
      :selected="selected"
      @set-selected="setSelected"
      :transport="channelStore.channels[channelId]['transport']"
    ></edit-channel>

    <hr style="width: 50%;">
    <save-button
      @click-handle="$emit('saveHandle','channels')"
    ></save-button>
  `
}
