const WhatsappChannel = {
  props: {
    selected: {
      type: String,
      default: "",
    },
    channelId: {
      type: String,
      default: "",
    },
  },

  setup(props) {
    const channelStore = useChannelsTabWazzupExtensionStore();
    const metaTables = inject("metaTables");
    const metaFields = inject("metaFields");
    const metaFilters = inject("metaFilters");

    const tableId = computed(() => {
      let temp = channelStore.channels[props.channelId]["additional_option"];
      let currentTable = temp.filter((i) => i.id == props.selected)[0];
      return currentTable?.table_id || 0;
    });

    const fullName = computed(() => {
      let temp = channelStore.channels[props.channelId]["additional_option"];
      let currentTable = temp.filter((i) => i.id == props.selected)[0];
      return currentTable?.client_name_field_id || 0;
    });

    const responsibleManager = computed(() => {
      let temp = channelStore.channels[props.channelId]["additional_option"];
      let currentTable = temp.filter((i) => i.id == props.selected)[0];
      return currentTable?.responsible_manager_field_id || 0;
    });

    const phoneFieldId = computed(() => {
      let temp = channelStore.channels[props.channelId]["additional_option"];
      let currentTable = temp.filter((i) => i.id == props.selected)[0];
      return currentTable?.phone_field_id || 0;
    });

    const priority = computed(() => {
      let temp = channelStore.channels[props.channelId]["additional_option"];
      let currentTable = temp.filter((i) => i.id == props.selected)[0] || "low";
      return currentTable?.priority || "low";
    });

    const filter = computed(() => {
      let temp = channelStore.channels[props.channelId]["additional_option"];
      let currentTable = temp.filter((i) => i.id == props.selected)[0];
      return currentTable?.filter || 0;
    });

    watch(
      [tableId, fullName, responsibleManager, phoneFieldId, priority, filter],
      (_) =>
        setTimeout((_) => $("select.chosen_add").trigger("chosen:updated"), 0)
    );

    // Инициализация chosen с функцией при change
    function initChosen() {
      $(".chosen_add")
        .chosen()
        .change(function (event) {
          let selectAttr = event.target.getAttribute("data-feature");
          let selectValue = event.target.value;
          setValue(selectAttr, selectValue);
        });
    }

    function setValue(key, value) {
      channelStore.channels[props.channelId]["additional_option"].forEach(
        (i) => {
          if (i.id == props.selected) {
            i[key] = value;
          }
        }
      );
    }

    onMounted(() => {
      checkHelpButtonsOnCurrentPage();
      bind_help_bt("wazzup");
      initChosen();
    });

    return {
      channelStore,
      metaTables,
      metaFields,
      metaFilters,
      tableId,
      phoneFieldId,
      priority,
      filter,
      fullName,
      responsibleManager,

      setValue,

      getFilters() {
        let t_id = Number(tableId.value);
        if (t_id <= 0) {
          return {};
        }

        let arr = [];
        Object.keys(metaFilters[t_id]).forEach((i) => {
          arr.push({
            id: metaFilters[t_id][i].id,
            name: metaFilters[t_id][i].name,
          });
        });
        return arr;
      },
    };
  },

  template: /*html*/ `
    <div class="current-selected-table">
      <div class="current-selected-table__name">
        <span>{{ $t('Table') }}</span>
        <span h_id="wazzup_channel_table" class="help_bt"></span>
        <span>:</span>
      </div>

      <div class="current-selected-table__select" style="display: flex; align-items: center;">
        <select
          class="form-control chosen_add"
          v-model="tableId"
          data-feature="table_id"
        >
          <option value="0"></option>
          <template v-for="table in metaTables">
            <option :value="table.id">{{ table.name }}</option>
          </template>
        </select>

        <div v-if="tableId > 0" style="display: flex;">
          <a :href="'edit_field.php?table=' + tableId" target="_blank" class="user-data__settings settings"></a>
        </div>
      </div>

      <div class="current-selected-table__name">
        <span>{{ $t('priority') }}</span>
        <span h_id="wazzup_channel_priopity" class="help_bt"></span>
        <span>:</span>
      </div>
      <div class="current-selected-table__select">
        <select
          class="form-control"
          v-model="priority"
          @change="setValue('priority', $event.target.value)"
        >
          <template v-for="pr in ['low','medium','high']">
            <option :value="pr">{{ $t(pr) }}</option>
          </template>
        </select>
      </div>

      <div class="current-selected-table__name">
        <span>{{ $t('client_name_field_label') }}</span>
        <span h_id="wazzup_channel_client_name" class="help_bt"></span>
        <span>:</span>
      </div>
      <div class="current-selected-table__select">
        <select
          class="form-control chosen_add"
          v-model="fullName"
          data-feature="client_name_field_id"
        >
          <option value="0"></option>
          <template v-for="field in metaFields[tableId] || []">
            <option
              v-if="field.type == 3"
              :value="field.id"
            >{{ field.name }}</option>
          </template>
        </select>
      </div>

      <div class="current-selected-table__name">
        <span>{{ $t('responsible_manager_field_label') }}</span>
        <span h_id="wazzup_channel_responsible_manager" class="help_bt"></span>
        <span>:</span>
      </div>
      <div class="current-selected-table__select">
        <select
          class="form-control chosen_add"
          v-model="responsibleManager"
          data-feature="responsible_manager_field_id"
        >
          <option value="0"></option>
          <template v-for="field in metaFields[tableId] || []">
            <option
              v-if="field.type == 7 || field.type == 11"
              :value="field.id"
            >{{ field.name }}</option>
          </template>
        </select>
      </div>

      <div class="current-selected-table__name">
        <span>{{ $t('phone_field') }}</span>
        <span h_id="wazzup_channel_field" class="help_bt"></span>
        <span>:</span>
      </div>
      <div class="current-selected-table__select">
        <select
          class="form-control chosen_add"
          v-model="phoneFieldId"
          data-feature="phone_field_id"
        >
          <option value="0"></option>
          <template v-for="field in metaFields[tableId] || []">
            <option :value="field.id">{{ field.name }}</option>
          </template>
        </select>
      </div>

      <div class="current-selected-table__name">
        <span>{{ $t('filter') }}</span>
        <span h_id="wazzup_channel_filter" class="help_bt"></span>
        <span>:</span>
      </div>
      <div class="current-selected-table__select" style="display: flex; align-items: center;">
        <select
          class="form-control chosen_add"
          v-model="filter"
          data-feature="filter"
        >
          <option value="0"></option>
          <template v-for="filter in getFilters()">
            <option :value="filter.id">{{ filter.name }}</option>
          </template>
        </select>

        <div v-if="tableId > 0 && filter > 0" style="display: flex;">
          <a :href="'edit_filter.php?table=' + tableId + '&filter=' + filter" target="_blank" class="user-data__settings settings"></a>
        </div>
      </div>
    </div>
  `,
};
