export const style = /*css*/`
  .navigation-panel {
    display: flex;
    justify-content: space-evenly;
    width: 300px;
    margin: 0 auto;
    margin-bottom: 22px;
  }

  .navigation-panel span {
    font-size: 13px;
    font-weight: normal;
  }

  .navigation-panel span:nth-child(2n+1) {
    cursor: pointer;
    color: blue;
  }

  .navigation-panel__active {
    color: black !important;
    cursor: auto !important;
  }

  .wazzup__container {
    display: flex;
    flex-direction: column;
    align-items: center;
  }

  .wazzup__content {
    display: flex;
    flex-direction: column;
    align-items: center;
  }

  .wazzup__content div:nth-child(n) {
    padding: 10px 0;
  }

  .wazzup__key_block {
    display: flex;
    align-items: center;
    justify-content: space-evenly;
    width: 545px;
  }

  .wazzup__key_block input {
    width: 250px;
  }

  .wazzup__webhook_block {
    display: grid;
    grid-template-rows: 1fr;
    grid-template-columns: 83px 20px 7px .1fr 1fr .1fr;
    justify-content: center;
    align-items: center;
    grid-gap: 0;
  }

  .wazzup__channels_list {
    padding-left: 35%;
    margin-bottom: 30px;
  }

  .wazzup__channel_item {
    display: flex;
    flex-direction: column;
    align-items: center;
  }

  .wazzup__channels_list__item {
    display: flex;
    flex-direction: row;
    align-items: center;
    margin-bottom: 5px;
  }

  .wazzup__channels_list__item img {
    margin: 0 2px 0 10px;
    font-size: 16px;
    height: 16px;
    width: 16px;
  }

  .wazzup__channel_item table {
    border-collapse: collapse;
    border: none;
    text-align: center;
  }

  .wazzup__channel_item table tr td:nth-child(1) {
    text-align: end;
    width: 150px;
    margin: 0;
    padding: 0;
  }

  .wazzup__channel_item table tr td:nth-child(2) {
    width: 28px;
    margin: 0;
    padding: 0;
  }

  .wazzup__channel_item table tr td:nth-child(2) span:nth-child(2) {
    margin-left: 2px;
  }

  .wazzup__channel_item table tr td:nth-child(3) {
    text-align: left;
  }

  .wazzup__channel_item table tr td:nth-child(3) input {
    width: 310px;
  }

  .wazzup__channel_item table tr td:nth-child(3) select {
    width: 300px;
  }

  .wazzup__users_list-table caption {
    text-align: center;
    color: black;
  }

  .wazzup__access-block {
    display: grid;
    grid-template-columns: 1fr 1.2fr;
    margin-bottom: 20px;
  }

  .wazzup__access-block div:nth-child(1) {
    grid-column: 1/3;
    text-align: center;
    font-size: 16px;
    font-weight: 600;
    padding-bottom: 8px;
  }

  .wazzup__access-block__input {
    text-align: end;
  }

  .wazzup__access-block__span {
    text-align: left;
    padding-left: 8px;
    font-size: 14px;
  }

  .current-selected-table {
    width: 60%;
    display: grid;
    grid-template-columns: 1fr 1fr;
    margin: auto 20%;
    grid-gap: 6px;
    align-items: center;
  }

  .current-selected-table__name {
    justify-self: end;
  }

  .current-selected-table__select select {
    width: 226px;
  }

  .migrate-component {
    display: flex;
    flex-direction: column;
    align-items: center;
    margin-bottom: 20px;
  }

  .migrate-component__row {
    display: flex;
    flex-direction: row;
    align-items: center;
    justify-content: center;
    margin: 15px 0;
  }

  .migrate-component__row span:nth-child(1) {
    width: 95px;
  }

  .migrate-component__row span:nth-child(2) {
    width: 25px;
    margin: 0;
  }

  .migrate-component__row span:nth-child(3) {
    width: 5px;
    margin-right: 4px;
  }

  .additionally-def_chan_for_reminder {
    display: flex;
    width: 100%;
    justify-content: center;
    align-items: center;
    gap: 5px;
  }

  .additionally-def_chan_for_reminder select {
    width: 220px;
  }
`
