import useScopedStyleMixin from '../../useScopedStyleMixin.js';
import TextStyles from './TextStyles.js';

const Text = {
  name: 'text',
  props: {
    storeFieldId: String,
    dataSource: Object,
  },
  data() {
    return {
      componentClass: 'text',
    }
  },
  computed: {
    text() {
      let text = this.dataSource[this.storeFieldId];
      for (let key in this.dataSource) {
        let value = this.dataSource[key];
        text = text.replace("{{" + key + "}}", value);
      }
      return text;
    }
  },
  mixins: [
    useScopedStyleMixin, 
    TextStyles
  ],
  template: /*html*/`
    <span
      :class="componentClass + hash"
    >
      {{ text }}
    <span/>
  `
};

export default Text;