import Dropdown from "./Dropdown/Dropdown.js";
import DatetimeCondition from "./DatetimeCondition/DatetimeCondition.js";
import Link from "./Link/Link.js";
import RadioButton from "./RadioButton/RadioButton.js";
import Checkbox from "./Checkbox/Checkbox.js";
import Text from "./Text/Text.js";

const c = {};

c['text'] = Text;
c['input-text'] = {
  props: {
    storeFieldId: String,
    dataSource: Object,
    dataValue: String,
    required: String,
    size: String
  },

  template: /*html*/`
    <input
      type="text"
      :required="required"
      v-model="dataSource[storeFieldId]"
      :fieldsize="size"
      class="form-control"
      autocomplete="off"
    />
  `,
};

c['input-file'] = {
  props: {
    storeFieldId: String,
    dataSource: Object,
    dataValue: String,
    required: String,
    size: String
  },

  methods: {
    onFileChange(event) {
      const file = event.target.files[0];
      this.dataSource[this.storeFieldId] = file;
    },
  },

  computed: {
    isRequired() {
      //Если файл ранее был загружен (есть в данных), поле не обязательное
      return !this.dataSource[this.storeFieldId]?.name && this.required;
    }
  },

  template: /*html*/`
    <input type="file" :required="isRequired" @change="onFileChange" />
    <template v-if="dataSource[storeFieldId]?.name">
      <span class="file-field-value">{{dataSource[storeFieldId].name}}</span>
    </template>
  `,
};

c['input-password'] = {
  props: {
    storeFieldId: String,
    dataSource: Object,
    dataValue: String,
    required: String,
    size: String
  },

  template: /*html*/`
    <input type="password" :required="required" v-model="dataSource[storeFieldId]" :fieldsize="size" class="form-control" autocomplete="off"/>
  `,
};

c['link'] = Link;

c['input-textarea'] = {
  props: {
    storeFieldId: String,
    dataSource: Object,
    dataValue: String,
    required: String,
    size: String
  },

  template: /*html*/`
    <textarea
      :required="required"
      v-model="dataSource[storeFieldId]"
      :fieldsize="size"
      class="form-control"
    ></textarea>
  `
};

c['template'] = {
  components: { 'Dropdown': primevue.dropdown },
  props: {
    storeFieldId: String,
    dataSource: Object,
    dataValue: String,
    options: Object,
    required: Boolean,
    size: String,
    width: String,
    default: String,
    insertTo: String, // поле, куда вставлять
    hideTextarea: Boolean, // прячем textarea, если вставляем в другое поле
    returnValue: { type: String, default: 'value' }, // поле, которое возвращаем
    clearInsertTo: { type: Boolean, default: false }, // очищаем поле, куда вставлять
    escapeBrackets: { type: Boolean, default: true }, // экранируем скобки
    nullLabel: { type: String, default: ' - вставить поле - ' } // label для пустого элемента
  },
  data() {
    return {
      selectedOption: 0
    };
  },
  
  computed: {
    textareaRef() {
      // Используем storeFieldId для создания уникального ref для textarea
      return `textarea-${this.storeFieldId}`;
    },
    isOptionsAvailable() {
      return this.normalizedOptions.length > 1; // с учётом пустого элемента
    },
    // нормализация: id, короткий label для отображения, полный value для вставки
    normalizedOptions() {
      const arr = [{ id: 0, label: this.nullLabel, value: '' }];
      const src = this.options || {};
      for (const [id, raw] of Object.entries(src)) {

        // JSON у тебя: { "<ID/длинный текст>": "<Label/короткий текст>" }
        if (raw && typeof raw === 'object') {
          const label = raw.label ?? String(id);
          const value = raw.value ?? label;
          arr.push({ id, label, value });
        } else {
          const label = String(raw ?? '');
          const value = label; // правая часть — значение по умолчанию
          arr.push({ id, label, value });
        }
      }
      return arr;
    },

    // если вставляем в другое поле — прячем свой textarea автоматически
    computedHideTextarea() {
      return this.hideTextarea || (!!this.insertTo && this.insertTo !== this.storeFieldId);
    }
  },
    methods: {
    getSelected() {
      return this.normalizedOptions.find(o => o.id === this.selectedOption);
    },
    resolveTargetField() {
      let f = this.insertTo || this.storeFieldId;

      if (this.ds && Object.prototype.hasOwnProperty.call(this.ds, f)) return f;

      const suffix = f;
      const k = Object.keys(this.ds || {}).find(
        key => key === suffix || key.endsWith('_' + suffix) || key.endsWith(suffix)
      );
      if (k) return k;

      // --- ДОБАВЛЕНО: ищем textarea в DOM по name/id ---
      const ta = document.querySelector(`textarea[name$="${suffix}"], textarea[id$="${suffix}"]`);
      if (ta) return ta.getAttribute('name') || ta.getAttribute('id');

      return f;
    },
    getCkeditorInstance() {
      const CK = window.CKEDITOR?.instances || {};
      for (const id in CK) {
        const el = CK[id]?.element;
        if (el && (el.getAttribute('name') === 'message' || el.getAttribute('id') === 'message')) {
          return CK[id];
        }
      }
      const ids = Object.keys(CK);
      return ids.length ? CK[ids[0]] : null;
    },

    onDropdownChange() {
      if (!this.selectedOption) return;
      const sel = this.getSelected();
      if (!sel) return;

      // Что именно вставлять: id (левая часть) или value (правая часть)
      let toInsert = (this.returnValue === 'id') ? String(sel.id) : (sel.value ?? sel.label);

      // Обернуть в { } ?
      if (this.escapeBrackets) {
        toInsert = `{${toInsert}}`;
      }

      const targetField = this.resolveTargetField();
      const isSelf = targetField === this.storeFieldId;

      // === ГАРАНТИЯ РЕАКТИВНОСТИ ДЛЯ ЦЕЛЕВОГО ПОЛЯ ===
      // Если ключа ещё нет в dataSource — добавляем его реактивно
      if (!(targetField in (this.dataSource || {}))) {
        if (typeof this.$set === 'function') {
          // Vue 2
          this.$set(this.dataSource, targetField, '');
        } else {
          // Vue 3 (proxy) — достаточно простой записи
          this.dataSource[targetField] = '';
        }
      }

      // CKEditor
      const inst = this.getCkeditorInstance();
      if (inst) {
        // В визуальном режиме — вставляем/перезаписываем HTML
        if (inst.mode !== 'source') {
          const html = this.escapeBrackets
            ? toInsert.replace(/\{/g, '&#123;').replace(/\}/g, '&#125;')
            : toInsert;

          if (this.clearInsertTo) {
            inst.setData(html);
          } else {
            inst.insertHtml(html);
          }
          return;
        }

        // source-режим — работаем с моделью
        this.dataSource[targetField] = this.clearInsertTo
          ? toInsert
          : ((this.dataSource?.[targetField] || '') + toInsert);
        return;
      }

      // Свой textarea — вставка по курсору или перезапись
      if (isSelf) {
        const ta = this.$refs[this.textareaRef];
        if (!ta) return;
        if (this.clearInsertTo) {
          this.dataSource[this.storeFieldId] = toInsert;
        } else {
          const cur = (this.dataSource[this.storeFieldId] || '').toString();
          const newVal = cur.slice(0, ta.selectionStart) + toInsert + cur.slice(ta.selectionEnd);
          this.dataSource[this.storeFieldId] = newVal;
        }
        return;
      }

      // Другое поле без CKEditor
      this.dataSource[targetField] = this.clearInsertTo
        ? toInsert
        : ((this.dataSource?.[targetField] || '') + toInsert);
    }
  },
  template: /*html*/`
 <div>
   <textarea
     v-if="!computedHideTextarea"
     :required="required"
     v-model="dataSource[storeFieldId]"
     :fieldsize="size"
     class="form-control"
     :ref="textareaRef"
     :name="storeFieldId"
     :id="storeFieldId"
   ></textarea>
  <br v-if="!computedHideTextarea"/>
  <Dropdown
    v-if="isOptionsAvailable"
    :size="size"
    :options="normalizedOptions"
    width="100%"
    v-model="selectedOption"
    optionLabel="label"
    optionValue="id"
    :filter="normalizedOptions.length > 8"
    filter-placeholder=""
  >
    <template #value="{ value, placeholder }">
      <span
        :title="(normalizedOptions.find(o => o.id === value) || {}).value || ''"
        style="display:block; white-space:nowrap; overflow:hidden; text-overflow:ellipsis; max-width:100%;"
      >
        {{ (normalizedOptions.find(o => o.id === value) || {}).label || placeholder }}
      </span>
    </template>

    <template #option="{ option }">
      <div :title="option.value" style="white-space:nowrap; overflow:hidden; text-overflow:ellipsis; max-width:100%;">
        {{ option.label }}
      </div>
    </template>
  </Dropdown>
    <div class="div-btn" @click="onDropdownChange">ОК</div>
</div>
`}
c['file_in'] = c['input-file'];

c['dropdown'] = Dropdown;

c['checkbox'] = Checkbox;

c['radiobutton'] = RadioButton;

c['colorpicker'] = {
  props: {
    storeFieldId: String,
    dataSource: Object,
    dataValue: String
  },

  template: /*html*/`
    <input type="text" class="colorSelector" id="{{storeFieldId}}" :value="dataSource[storeFieldId]">
    <input type=hidden name="{{storeFieldId}}" v-model="dataSource[storeFieldId]">
  `
};

c['input-date'] = {
  props: {
    storeFieldId: String,
    dataSource: Object,
    dataValue: String,
    required: String,
    size: String
  },

  template: /*html*/`
    <input type="date" :required="required" v-model="dataSource[storeFieldId]" :fieldsize="size" class="form-control" />
  `,
};

c['input-datetime'] = {
  props: {
    storeFieldId: String,
    dataSource: Object,
    dataValue: String,
    required: String,
    size: String
  },

  template: /*html*/`
    <input type="datetime-local" :required="required" v-model="dataSource[storeFieldId]" :fieldsize="size" class="form-control"  />
  `,
};

c['datetime-condition'] = DatetimeCondition;

c['html'] = {
  props: {
    storeFieldId: String,
    dataSource: Object,
    dataValue: String,
  },

  template: /*html*/`
    <div v-html="dataSource[storeFieldId]"></div>
  `,
};

export const components = c;
