const useScopedStyleMixin = {
  data() {
    return {
      hash: '_' + Math.random().toString(36).substr(2, 10) // Генерируем уникальный хэш
    };
  },
  beforeMount() {
    //console.log(`[Mixin] Injecting styles for hash: ${this.hash}`);
    this.injectStyles();
  },
  mounted() {
    this.$nextTick(() => {
      //console.log(`[Mixin] Ensuring styles for hash: ${this.hash}`);
      this.injectStyles();
    });
  },
  methods: {
    injectStyles() {
      const styleId = `style-${this.hash}`;
      let styleTag = document.getElementById(styleId);

      if (!styleTag) {
        styleTag = document.createElement("style");
        styleTag.id = styleId;
        document.head.appendChild(styleTag);
      }

      if (typeof this.generateStyles === 'function') {
        styleTag.textContent = this.generateStyles();
      } else {
        console.warn(`[Mixin] generateStyles() is not defined in component with hash: ${this.hash}`);
      }
    }
  }
};

export default useScopedStyleMixin;