import useTranslate from "../../../hooks/useTranslate.js";
import { App } from "./App.js";
import useKOSearchBlockStore from "./store/index.js";


/**
 * Сформировать компонент блока поиска.
 *
 * @param {Object} ko_settings  Настройки блока
 */
export default async function(ko_settings) {
  // console.log(ko_settings);

  const app = Vue.createApp(App);
  app.use(Pinia.createPinia())

  const store = useKOSearchBlockStore();
  store.setValue('block_id',   (ko_settings?.block_id || 0));
  store.setValue('block_name', (ko_settings?.block_name || ""));
  store.setValue('caption',    (ko_settings?.caption || useTranslate("Search")));
  store.setValue('table_id',   (ko_settings?.table_id || 0));
  store.setValue('use_links',  (ko_settings?.use_links || "implicit"));
  store.setValue('sort',       (ko_settings?.sort || ""));
  store.setValue('limit',      (ko_settings?.limit || 50));
  store.setValue('alignment',  (ko_settings?.alignment || "center"));
  store.setValue('statuses',   (ko_settings?.statuses || ""));
  store.setValue('columns',    (ko_settings?.columns || []));

  const block_name = store.getValue("block_name");

  window["search_block_values"] = "search_block_values" in window
    ? window["search_block_values"] : [];

  window["report_search_blocks"] = "report_search_blocks" in window
    ? window["report_search_blocks"] : {};

  window["report_search_blocks"][block_name] = (
    block_name in window["report_search_blocks"]
      ? window["report_search_blocks"][block_name] : ko_settings
  );

  store.setValue('search_string', (
    block_name in window["search_block_values"]
      ? window["search_block_values"][block_name] : ""
  ));

  app.mount(`#${block_name}`);
}
