{include file="./index_top.tpl"}
<script type="text/javascript">
    cpkNewCol = "{$lang.cp_new_color}";
    cpkCurCol = "{$lang.cp_cur_color}";

    // значения для системной подсказки
    var help_section = 'Settings';
    var help_sub_section = 'Formatting';
</script>
<script>
    var under_mouse_object = 0;
    var last_focus = 0;
    let isFirstLoad = true;

    {literal}
    function strtotime(str, now) {
        // http://kevin.vanzonneveld.net
        // +   original by: Caio Ariede (http://caioariede.com)
        // +   improved by: Kevin van Zonneveld (http://kevin.vanzonneveld.net)
        // +      input by: David
        // +   improved by: Caio Ariede (http://caioariede.com)
        // +   improved by: Brett Zamir (http://brett-zamir.me)
        // +   bugfixed by: Wagner B. Soares
        // +   bugfixed by: Artur Tchernychev
        // +   input by: wookie
        // %        note 1: Examples all have a fixed timestamp to prevent tests to fail because of variable time(zones)
        // *     example 1: strtotime('+1 day', 1129633200);
        // *     returns 1: 1129719600
        // *     example 2: strtotime('+1 week 2 days 4 hours 2 seconds', 1129633200);
        // *     returns 2: 1130425202
        // *     example 3: strtotime('last month', 1129633200);
        // *     returns 3: 1127041200
        // *     example 4: strtotime('2009-05-04 08:30:00');
        // *     returns 4: 1241418600
        var i, l, match, s, parse = '';

        str = (str + '').replace(/\s{2,}|^\s|\s$/g, ' ').replace(/[\t\r\n]/g, ''); // unecessary spaces and chars

        if (str === 'now') {
            return now === null || isNaN(now) ? new Date().getTime() / 1000 | 0 : now | 0;
        } else if (!isNaN(parse = Date.parse(str))) {
            return parse / 1000 | 0;
        } else if (now) {
            now = new Date(now * 1000); // Accept PHP-style seconds
        } else {
            now = new Date();
        }

        str = str.toLowerCase();

        var __is = {
            day: {
                'sun': 0,
                'mon': 1,
                'tue': 2,
                'wed': 3,
                'thu': 4,
                'fri': 5,
                'sat': 6
            },
            mon: [
                'jan',
                'feb',
                'mar',
                'apr',
                'may',
                'jun',
                'jul',
                'aug',
                'sep',
                'oct',
                'nov',
                'dec'
            ]
        };

        var process = function (m) {
            var ago = (m[2] && m[2] === 'ago');
            var num = (num = m[0] === 'last' ? -1 : 1) * (ago ? -1 : 1);

            switch (m[0]) {
                case 'last':
                case 'next':
                    switch (m[1].substring(0, 3)) {
                        case 'yea':
                            now.setFullYear(now.getFullYear() + num);
                            break;
                        case 'wee':
                            now.setDate(now.getDate() + (num * 7));
                            break;
                        case 'day':
                            now.setDate(now.getDate() + num);
                            break;
                        case 'hou':
                            now.setHours(now.getHours() + num);
                            break;
                        case 'min':
                            now.setMinutes(now.getMinutes() + num);
                            break;
                        case 'sec':
                            now.setSeconds(now.getSeconds() + num);
                            break;
                        case 'mon':
                            if (m[1] === "month") {
                                now.setMonth(now.getMonth() + num);
                                break;
                            }
                            // fall through
                        default:
                            var day = __is.day[m[1].substring(0, 3)];
                            if (typeof day !== 'undefined') {
                                var diff = day - now.getDay();
                                if (diff === 0) {
                                    diff = 7 * num;
                                } else if (diff > 0) {
                                    if (m[0] === 'last') {
                                        diff -= 7;
                                    }
                                } else {
                                    if (m[0] === 'next') {
                                        diff += 7;
                                    }
                                }
                                now.setDate(now.getDate() + diff);
                                now.setHours(0, 0, 0, 0); // when jumping to a specific last/previous day of week, PHP sets the time to 00:00:00
                            }
                    }
                    break;

                default:
                    if (/\d+/.test(m[0])) {
                        num *= parseInt(m[0], 10);

                        switch (m[1].substring(0, 3)) {
                            case 'yea':
                                now.setFullYear(now.getFullYear() + num);
                                break;
                            case 'mon':
                                now.setMonth(now.getMonth() + num);
                                break;
                            case 'wee':
                                now.setDate(now.getDate() + (num * 7));
                                break;
                            case 'day':
                                now.setDate(now.getDate() + num);
                                break;
                            case 'hou':
                                now.setHours(now.getHours() + num);
                                break;
                            case 'min':
                                now.setMinutes(now.getMinutes() + num);
                                break;
                            case 'sec':
                                now.setSeconds(now.getSeconds() + num);
                                break;
                        }
                    } else {
                        return false;
                    }
                    break;
            }
            return true;
        };

        match = str.match(/^(\d{2,4}-\d{2}-\d{2})(?:\s(\d{1,2}:\d{2}(:\d{2})?)?(?:\.(\d+))?)?$/);
        if (match !== null) {
            if (!match[2]) {
                match[2] = '00:00:00';
            } else if (!match[3]) {
                match[2] += ':00';
            }

            s = match[1].split(/-/g);

            s[1] = __is.mon[s[1] - 1] || s[1];
            s[0] = +s[0];

            s[0] = (s[0] >= 0 && s[0] <= 69) ? '20' + (s[0] < 10 ? '0' + s[0] : s[0] + '') : (s[0] >= 70 && s[0] <= 99) ? '19' + s[0] : s[0] + '';
            return parseInt(this.strtotime(s[2] + ' ' + s[1] + ' ' + s[0] + ' ' + match[2]) + (match[4] ? match[4] / 1000 : ''), 10);
        }

        var regex = '([+-]?\\d+\\s' + '(years?|months?|weeks?|days?|hours?|min|minutes?|sec|seconds?' + '|sun\\.?|sunday|mon\\.?|monday|tue\\.?|tuesday|wed\\.?|wednesday' + '|thu\\.?|thursday|fri\\.?|friday|sat\\.?|saturday)' + '|(last|next)\\s' + '(years?|months?|weeks?|days?|hours?|min|minutes?|sec|seconds?' + '|sun\\.?|sunday|mon\\.?|monday|tue\\.?|tuesday|wed\\.?|wednesday' + '|thu\\.?|thursday|fri\\.?|friday|sat\\.?|saturday))' + '(\\sago)?';

        match = str.match(new RegExp(regex, 'gi')); // Brett: seems should be case insensitive per docs, so added 'i'
        if (match === null) {
            return false;
        }

        for (i = 0, l = match.length; i < l; i++) {
            if (!process(match[i].split(' '))) {
                return false;
            }
        }

        return now.getTime() / 1000 | 0;
    }
    {/literal}

    function set_date_promt(num) {
        let condValue = $('#cond_value_' + num).val();

        if (condValue && condValue.substr(0, 5) == 'date(') {
            var date_type = condValue;
            switch (date_type) {
                case "date('W')":
                    var date0 = {$begin_week};
                    var date0_end = {$end_week};
                    break
                case "date('m')":
                    var date0 = {$begin_month};
                    var date0_end = {$end_month};
                    break
                case "date('Y')":
                    var date0 = {$begin_year};
                    var date0_end = {$end_year};
                    break
                default:
                    var date0 = strtotime('now');
                    var date0_end = strtotime('now');
                    break
            }
            if ($('#cond_oper_' + num).val() == " + interval ") {
                if ($('#cond_interval_' + num).val() && $('#cond_period_' + num).val()) {
                    var inter0 = '+' + $('#cond_interval_' + num).val() + ' ' + $('#cond_period_' + num).val();
                    inter1 = strtotime(inter0, date0);
                    var date1 = new Date(inter1 * 1000);
                    inter_end = strtotime(inter0, date0_end);

                    if ((date_type == "date('m')") && ($('#cond_period_' + num).val() == ' month'))
                        var date1_end = new Date(date1.getFullYear(), date1.getMonth(), new Date(date1.getFullYear(), date1.getMonth() + 1, 0).getDate(), 23, 59, 59);
                    else
                        var date1_end = new Date(inter_end * 1000);
                } else {
                    return false;
                }
            } else if ($('#cond_oper_' + num).val() == " - interval ") {
                if ($('#cond_interval_' + num).val() && $('#cond_period_' + num).val()) {
                    var inter0 = '-' + $('#cond_interval_' + num).val() + ' ' + $('#cond_period_' + num).val();
                    inter1 = strtotime(inter0, date0);
                    var date1 = new Date(inter1 * 1000);
                    inter_end = strtotime(inter0, date0_end);

                    if ((date_type == "date('m')") && ($('#cond_period_' + num).val() == ' month'))
                        var date1_end = new Date(date1.getFullYear(), date1.getMonth(), new Date(date1.getFullYear(), date1.getMonth() + 1, 0).getDate(), 23, 59, 59);
                    else
                        var date1_end = new Date(inter_end * 1000);
                } else {
                    return false;
                }
            } else {
                var date1 = new Date(date0 * 1000);
                var date1_end = new Date(date0_end * 1000);
            }

            if ((date1.getDate()).toString().length == 2) {
                var toDay = (date1.getDate()).toString();
            } else {
                var toDay = '0' + (date1.getDate()).toString();
            }

            if ((date1.getMonth() + 1).toString().length == 2) {
                var month = (date1.getMonth() + 1).toString();
            } else {
                var month = '0' + (date1.getMonth() + 1).toString();
            }

            if ((date1.getHours()).toString().length == 2) {
                var Hours = (date1.getHours()).toString();
            } else {
                var Hours = '0' + (date1.getHours()).toString();
            }

            if ((date1.getMinutes()).toString().length == 2) {
                var Minutes = (date1.getMinutes()).toString();
            } else {
                var Minutes = '0' + (date1.getMinutes()).toString();
            }
            //изменение даты в подсказке при +- дней, месяцев, недель
            var cur_oper = $("#cond_oper_" + num).val();
            var cur_interval = $("#cond_interval_" + num).val();
            var cur_period = $("#cond_period_" + num).val();
            var curYear = date1.getFullYear().toString();

            if (cur_oper == '+')
                cur_oper = 1;
            if (cur_oper == '-')
                cur_oper = 2;

            if (cur_oper && cur_interval && cur_period)
                $.ajax({
                    type: 'POST',
                    async: false,
                    url: 'edit_format.php',
                    data: 'prepare_date=1&oper=' + cur_oper + '&interval=' + cur_interval + '&period=' + cur_period + '&csrf={$csrf}&table={$table_id}',
                    success: function (data) {
                        my_result = data.split('-');
                        toDay = my_result[0];
                        month = my_result[1];
                        curYear = my_result[2];
                        Hours = my_result[3];
                        Minutes = my_result[4];
                    }
                });

            var date2 = toDay + '/' + month + '/' + curYear + ' ' + Hours + ':' + Minutes;

            if ((date1_end.getDate()).toString().length == 2) {
                var toDay = (date1_end.getDate()).toString();
            } else {
                var toDay = '0' + (date1_end.getDate()).toString();
            }

            if ((date1_end.getMonth() + 1).toString().length == 2) {
                var month = (date1_end.getMonth() + 1).toString();
            } else {
                var month = '0' + (date1_end.getMonth() + 1).toString();
            }

            if ((date1_end.getHours()).toString().length == 2) {
                var Hours = (date1_end.getHours()).toString();
            } else {
                var Hours = '0' + (date1_end.getHours()).toString();
            }

            if ((date1_end.getMinutes()).toString().length == 2) {
                var Minutes = (date1_end.getMinutes()).toString();
            } else {
                var Minutes = '0' + (date1_end.getMinutes()).toString();
            }

            var date2_end = toDay + '/' + month + '/' + date1_end.getFullYear().toString() + ' ' + Hours + ':' + Minutes;

            switch (date_type) {
                case "date('W')":
                case "date('m')":
                case "date('Y')":
                    var date3 = lang['since_from'] + ' ' + date2 + ' ' + lang['since_to'] + ' ' + date2_end;
                    break
                default:
                    var date3 = date2;
                    break
            }

            if ($('#cond_value_' + num).val() == 'date(\'Y-m-d\')') {
                pos_time = date2.indexOf(' ');
                date3 = date2.substr(0, pos_time + 1);
            }

            var term = $('#cond_term_' + num).val();
            switch (term) {
                case '=':
                    var field_str = date3;
                    break
                case '!=':
                    var field_str = lang['none'] + ' ' + date3;
                    break
                case '>':
                    var field_str = lang['later_than'] + ' ' + date3;
                    break
                case '<':
                    var field_str = lang['earlier_than'] + ' ' + date3;
                    break
                case '>=':
                    var field_str = date3 + ' ' + lang['or_later'];
                    break
                case '<=':
                    var field_str = date3 + ' ' + lang['or_earlier'];
                    break
                case ' like ':
                    var field_str = lang['contains'] + ' ' + date3;
                    break
                case ' not like ':
                    var field_str = lang['does_not_contain'] + ' ' + date3;
                    break
            }
            $('#date_promt_' + num).html(field_str + " <span class='help_bt' style='height:16px' title='" + lang.now_tip + "'>");
        }
        else {
            $('#date_promt_' + num).html('');
        }

        const condFieldId = $('#cond_field_' + num).val();
        const condTermVal = $('#cond_term_' + num).val();
        const field = search_fields[condFieldId];
        const fieldType = parseInt(field.type_field);
        const fieldMultVal = parseInt(field.mult_value);
        const isTermFocused = $('#cond_term_' + num).is(':focus');

        if (condTermVal === '=' && isTermFocused) checkFieldForMultiValAndShowTooltip(fieldType, fieldMultVal, 1);
        if (condTermVal === '!=' && isTermFocused) checkFieldForMultiValAndShowTooltip(fieldType, fieldMultVal, 2);
    }

    // ============ МАСТЕР УСЛОВИЙ ============ //

    var fields_id = [ {foreach $search_fields as $one_field}{$one_field.id}, {/foreach} ]; // массив id полей для правильной сортировки search_fields при его проходе (см. get_fields_options)

    var search_fields = {
        {foreach $search_fields as $one_field}'{$one_field.id}': {
            'id': '{$one_field.id}',
            'table_id': '{$one_field.table_id}',
            'name_field': '{$one_field.name_field|replace:'\\':'\\\\'|replace:"'":"\'"}', 'type_field':'{$one_field.type_field}', 'type_value':'{$one_field.type_value_js}', 'default_value':'{$one_field.default_value_js}', 'main':'{$one_field.main}', 'unique':'{$one_field.unique}', 'mult_value':'{$one_field.mult_value}', 'pp':'{$one_field.pp}', 'int_name':'{$one_field.int_name}', 'view':'{$one_field.view}', 'view_tb':'{$one_field.view_tb}', 'view_edit':'{$one_field.view_edit}', 'view_add':'{$one_field.view_add}', 'read':'{$one_field.read}', 'write':'{$one_field.write}', 'child_link_field':'{$one_field.child_link_field}', 'parent_link_field':'{$one_field.parent_link_field}', 's_field_id':'{$one_field.s_field_id}', 's_table_id':'{$one_field.s_table_id}', 's_field_filter_id':'{$one_field.s_field_filter_id}', 'view_html':'{$one_field.view_html}', 'input_value':"{$one_field.input_value}" }, {/foreach} };

            function get_fields_options()
    {
        var fields_options = "";
        for (var key in fields_id) {
            fields_options += "<option value=" + fields_id[key] + ">" + search_fields[fields_id[key]].name_field + "</option>";
        }
        return fields_options;
    }

    function get_term_options(field) {
        var term_options = "";
        if (field.type_field == 1 || field.type_field == 2 || field.type_field == 8 || field.type_field == 10 || field.type_field == 12)
            term_options = "<option value='='>{$lang['=']}</option><option value='!='>{$lang['!=']}</option><option value='>'>{$lang['>']}</option><option value='<'>{$lang['<']}</option><option value='>='>{$lang['>=']}</option><option value='<='>{$lang['<=']}</option>";
        if (field.type_field == 3 || (field.type_field == 4 && field.mult_value == 1) || (field.type_field == 5 && field.mult_value == 1) || field.type_field == 6 || (field.type_field == 7 && field.mult_value == 1) || field.type_field == 9 || (field.type_field == 14 && field.mult_value == 1) || field.type_field == -1)
            term_options = "<option value='='>{$lang['=']}</option><option value='!='>{$lang['!=']}</option><option value=' like '>{$lang['LIKE']}</option><option value=' not like '>{$lang['NOT LIKE']}</option>";
        if ((field.type_field == 4 && field.mult_value == 0) || (field.type_field == 5 && field.mult_value == 0) || (field.type_field == 7 && field.mult_value == 0) || (field.type_field == 14 && field.mult_value == 0) || field.type_field == 11 || field.type_field == 13)
            term_options = "<option value='='>{$lang['=']}</option><option value='!='>{$lang['!=']}</option>";

        return term_options;
    }

    function get_value_control(field, term, num) {
        var control = "";
        if (field.input_value.substring(0, 7) == "<option")
            control = "<select class='form-control form-control-160' name='cond_set[" + num + "][value]' id='cond_value_" + num + "' onChange='set_date_promt(" + num + "); set_expert();'>" + field.input_value + "</select>";
        else if (field.type_field == 5)
            control = "<select class='combobox' name='cond_set[" + num + "][value_link]' id='cond_value_" + num + "'></select>";
        else
            control = "<input class='form-control form-control-160' type=text name='cond_set[" + num + "][value]' id='cond_value_" + num + "' onChange='set_expert()'>";
        return control;
    }

    function get_union_options(num) {
        var union_options = "";
        union_options = ((num == last_num) ? "<option value=''></option>" : "") + "<option value=' and '>{$lang.and}</option><option value=' or '>{$lang.or}</option>";
        return union_options;
    }

    /**
     * Индексация для автокомплита
     * @type Number
     */
    var global_ac_index = 0;

    function set_search_controls(num, cond_field, cond_term, cond_value, cond_value_link, cond_oper, cond_interval, cond_period, cond_union, open_bracket, close_bracket) {
        if (!cond_field) cond_field = +$('#cond_field_' + num).val();
        var field = search_fields[cond_field];
        const fieldType = parseInt(field.type_field);
        const fieldMultVal = parseInt(field.mult_value);
        const termFocused =  $('#cond_term_' + num).is(':focus');
        const condFocused =  $('#cond_field_' + num).is(':focus');

        $('#cond_field_' + num).html(get_fields_options());
        $('#cond_field_' + num).val(cond_field);
        $('#cond_term_' + num).html(get_term_options(field));
        $('#cond_term_' + num).val(cond_term ? (termFocused ? cond_term : (fieldMultVal === 1 ? (condFocused ? ' like ' : cond_term) : cond_term)) : (fieldMultVal === 1 ? ' like ' : '='));
        $('#span_cond_value_' + num).html(get_value_control(field, cond_term, num));

        if (fieldType == 5) {
            create_ac_by_cond('#cond_value_' + num, global_ac_index, cond_value_link, cond_field, '{$table_id}', '{$filter_id}', set_expert);
            global_ac_index++;
        }
        if (fieldType == 2 || fieldType == 12) {
            $('#date_interval_' + num).css("display", "");
        } else {
            $('#date_interval_' + num).css("display", "none");
        }
        if ((fieldType == 2 || fieldType == 12) && !cond_value) {
            $('#cond_value_' + num).val("0000-00-00 00:00:00");
        } else if (fieldType == 13 && !cond_value) {
            $('#cond_value_' + num).val(0);
        } else if (fieldType == 14 && cond_value == "$user['group_name']") {
            $('#cond_value_' + num).val(
              {literal}field.mult_value == '0' ? '{current_group}' : '-{current_group}-'{/literal}
            );
        } else {
            $('#cond_value_' + num).val(cond_value);
        }
        $('#cond_oper_' + num).html("<option value=''></option><option value='+'>+</option><option value='-'>-</option>");
        $('#cond_period_' + num).html("<option value=''></option><option value='day'>" + lang.days + "</option><option value='month'>" + lang.months + "</option><option value='year'>" + lang.years + "</option><option value='hour'>" + lang.hours + "</option><option value='minute'>" + lang.minutes + "</option>");
        $('#cond_oper_' + num).val(cond_oper);
        $('#cond_interval_' + num).val(cond_interval);
        $('#cond_period_' + num).val(cond_period);
        $('#cond_union_' + num).html(get_union_options(num));
        $('#cond_union_' + num).val(cond_union);
        $('#cond_ob_' + num).val(+open_bracket ? 1 : 0);
        $('#cond_cb_' + num).val(+close_bracket ? 1 : 0);
        $('#span_ob_' + num).css('color', +open_bracket ? 'black' : '#ddd');
        $('#span_cb_' + num).css('color', +close_bracket ? 'black' : '#ddd');
        $('#span_ob_' + num).prop('title', +open_bracket ? lang.Disable_bracket: lang.Enable_bracket);
        $('#span_cb_' + num).prop('title', +open_bracket ? lang.Disable_bracket: lang.Enable_bracket);
        set_date_promt(num);

        //setTimeout(init_chosen, 0);
    }

    function add_cond(num, cond_field, cond_term, cond_value, cond_value_link, cond_oper, cond_interval, cond_period, cond_union, open_bracket, close_bracket) {
        last_num = num;
        var new_cond = "<div class='flex-wrap' id='cond_" + num + "' style='padding:2px; margin-top: 4px;'><img alt='{$lang.delete}' title='{$lang.Delete_condition}' src='images/b_drop.png' border=0 style='cursor:pointer; vertical-align:middle; padding-bottom:3px;margin-right: 3px;' onclick='del_cond(" + num + ")'> <span id='span_ob_" + num + "' class='brackets' style='cursor:pointer' onclick='set_bracket(\"ob_" + num + "\"); set_expert();'><b>(</b></span> <input type='hidden' name='cond_set[" + num + "][open_bracket]' id='cond_ob_" + num + "'> <span><select style='margin-right: 3px;' class='form-control form-control-250' name='cond_set[" + num + "][field]' id='cond_field_" + num + "' onChange='set_search_controls(" + num + "); set_expert();'></select></span <span><select class='form-control' name='cond_set[" + num + "][term]' id='cond_term_" + num + "' style='width:150px; margin-right: 3px;' onChange='set_date_promt(" + num + "); set_expert();'></select></span> <span id='span_cond_value_" + num + "'><input class='form-control' type=text id='cond_value_" + num + "'></span><span id='date_interval_" + num + "'><span><select class='form-control' name='cond_set[" + num + "][oper]' id='cond_oper_" + num + "' style='width:53px; margin-left:4px; margin-right:3px;' onChange='set_date_promt(" + num + "); set_expert();'></select></span> <input class='form-control' type=text name='cond_set[" + num + "][interval]' id='cond_interval_" + num + "' style='text-align:right; width:30px;' onChange='set_date_promt(" + num + "); set_expert();'> <span><select class='form-control' name='cond_set[" + num + "][period]' id='cond_period_" + num + "' style='width:80px' onChange='set_date_promt(" + num + "); set_expert();'></select></span></span> <span id='span_cb_" + num + "' class='brackets' style='cursor:pointer' onclick='set_bracket(\"cb_" + num + "\"); set_expert();'><b>)</b></span> <input type='hidden' name='cond_set[" + num + "][close_bracket]' id='cond_cb_" + num + "'> <span><select class='form-control' name='cond_set[" + num + "][union]' id='cond_union_" + num + "' style='width:53px' onChange='if (last_num==" + num + ") add_cond(" + (num + 1) + "); set_expert();'></select></span> &nbsp; <span id='date_promt_" + num + "' style='color:gray'></span></div>";
        if (num == 1) {
            $("#wizard_set").html(new_cond);
        }
        else {
            prev_cond_union = $('#cond_union_' + (num - 1)).val();
            $('#cond_union_' + (num - 1)).html(get_union_options((num - 1)));
            $('#cond_union_' + (num - 1)).val(prev_cond_union);
            $("#cond_" + (num - 1)).after(new_cond);
        }
        set_search_controls(num, cond_field, cond_term, cond_value, cond_value_link, cond_oper, cond_interval, cond_period, cond_union, open_bracket, close_bracket)
    }

    function set_bracket(id) {
        var bracket = ($('#cond_' + id).val() == '1') ? 0 : 1;
        $('#cond_' + id).val(bracket);
        $('#span_' + id).css('color', bracket ? 'black' : '#ddd');
        $('#span_' + id).prop('title', bracket ? lang.Disable_bracket: lang.Enable_bracket);
    }

    function del_cond(num) {
        $('#cond_' + num).remove();
        if (num == last_num) {
            for (var i = num - 1; i > 0; i--) {
                if (document.getElementById('cond_' + i)) {
                    last_num = i;
                    $('#cond_union_' + i).html(get_union_options(i));
                    break;
                }
            }
        }
        if (!$('#wizard_set').html()) add_cond(1);
        set_expert();
    }

    function set_expert(is_init = false) {
        var condition = '';
        var and_count = 0;
        var or_count = 0;

        for (var num = 1; num <= last_num; num++) {
            if (document.getElementById('cond_' + num) && $('#cond_field_' + num).val() > '0') {
                var cond_field = +$('#cond_field_' + num).val();
                var cond_term = $('#cond_term_' + num).val();
                var field = search_fields[cond_field];
                const firstCondVal = $('#cond_field_1').val();
                const firstCondTextVal = $('#cond_field_1').find('option[value="' + firstCondVal + '"]');

                if (last_num === 1 && !isFirstLoad) {
                    $('#format_target').val(firstCondVal).trigger('change');
                    $('#format_target .chosen-single span').text(firstCondTextVal);
                }
                if (field.type_field == 5) {
                    if (firstCondVal === "" || firstCondVal === null) {
                        var cond_value = $('#cond_value_' + num + ' [value=""]').html();
                        if (cond_value === undefined) {
                            cond_value = '';
                        }
                    } else {
                        var cond_value = $('#cond_value_' + num + ' [value="' + $('#cond_value_' + num).val() + '"]').html();
                    }
                    if (cond_value == '&nbsp;' || cond_value == ' ') {
                        cond_value = ''; // bugfix
                    }
                } else {
                    var cond_value = $('#cond_value_' + num).val();
                }
                var cond_oper = $('#cond_oper_' + num).val();
                var cond_interval = $('#cond_interval_' + num).val();
                var cond_period = $('#cond_period_' + num).val();
                var cond_union = $('#cond_union_' + num).val();
                var open_bracket = $('#cond_ob_' + num).val() == '1' ? '(' : '';
                var close_bracket = $('#cond_cb_' + num).val() == '1' ? ')' : '';
                if (search_fields[cond_field].type_field == 1 || search_fields[cond_field].type_field == 2 || search_fields[cond_field].type_field == 4 || search_fields[cond_field].type_field == 12)
                    var cond_field_line = "$cur_line['" + search_fields[cond_field].name_field.replace("'", "\\'") + "']['db_value']";
                else
                    var cond_field_line = "$cur_line['" + search_fields[cond_field].name_field.replace("'", "\\'") + "']['value']";
                if (cond_value == "date('W')")
                    cond_field = "date('W', strtotime(" + cond_field_line + "))";
                else if (cond_value == "date('m')")
                    cond_field = "date('m', strtotime(" + cond_field_line + "))";
                else if (cond_value == "date('Y')")
                    cond_field = "date('Y', strtotime(" + cond_field_line + "))";
                else
                    cond_field = cond_field_line;
                if (cond_term == "=") cond_term = "==";
                if (cond_value.substring(0, 5) != "date(" && cond_value.substring(0, 6) != '$user[') {
                    cond_value = "'" + cond_value.replace(/\\/g, "\\\\").replace(/'/g, "\\'") + "'";
                }
                if (cond_value.substring(0, 5) == "date(" && cond_oper) {
                    if (cond_period == "day") var days = "date('d')" + cond_oper + cond_interval; else var days = "date('d')";
                    if (cond_period == "month") var months = "date('m')" + cond_oper + cond_interval; else var months = "date('m')";
                    if (cond_period == "year") var years = "date('Y')" + cond_oper + cond_interval; else var years = "date('Y')";
                    if (cond_period == "hour") var hours = "date('H')" + cond_oper + cond_interval;
                    else if (cond_value == "date('Y-m-d H:i:s')") var hours = "date('H')";
                    else var hours = 0;
                    if (cond_period == "minute") var minutes = "date('i')" + cond_oper + cond_interval;
                    else if (cond_value == "date('Y-m-d H:i:s')") var minutes = "date('i')";
                    else var minutes = 0;
                    if (cond_period == "second") var seconds = "date('s')" + cond_oper + cond_interval;
                    else if (cond_value == "date('Y-m-d H:i:s')") var seconds = "date('s')";
                    else var seconds = 0;
                    cond_value = cond_value.substring(0, cond_value.length - 1) + ', mktime(' + hours + ', ' + minutes + ', ' + seconds + ', ' + months + ', ' + days + ', ' + years + '))';
                }
                if (cond_term == " like ")
                    one_cond = "mb_stripos(" + cond_field + ", " + cond_value + ")!==false";
                else if (cond_term == " not like ")
                    one_cond = "mb_stripos(" + cond_field + ", " + cond_value + ")===false";
                else if (cond_value.substring(0, 12) == "date('Y-m-d'")
                    one_cond = "substr(" + cond_field + ",0,10)" + cond_term + cond_value;
                else
                    one_cond = cond_field + cond_term + cond_value;
                if (cond_value.substring(0, 5) == "date(" &&
                        (cond_term.substring(0, 1) == '<' ||
                         cond_value.substring(0, 8) == "date('W'" ||
                         cond_value.substring(0, 8) == "date('m'" ||
                         cond_value.substring(0, 8) == "date('Y'")) {
                    one_cond = "(" + one_cond + " and " + cond_field_line + "!='0000-00-00 00:00:00')";
                }
                condition += open_bracket + one_cond + close_bracket + cond_union;
                and_count += (cond_union == ' and ') ? 1 : 0;
                or_count  += (cond_union == ' or ' ) ? 1 : 0;
            }
        }
        if (condition.substring(condition.length - 5) == " and ") condition = condition.substring(0, condition.length - 5);
        if (condition.substring(condition.length - 4) == " or ") condition = condition.substring(0, condition.length - 4);
        if (is_init === false) {
            // При инициализации значение подставляется из бд
            $("#condition").val(condition);
        }
        if (and_count == 0 || or_count == 0) {
            $('.brackets').css('visibility', 'hidden');
        } else {
            $('.brackets').css('visibility', 'visible');
        }

        isFirstLoad = false;

        setTimeout(init_chosen, 0);
    }

    function check_brackets() {
        var open_brackets = 0;
        var close_brackets = 0;
        for (var num = 1; num <= last_num; num++) {
            if (document.getElementById('cond_' + num) && $('#cond_field_' + num).val() > '0' && !$('#cond_field_' + num).prop("disabled")) {
                open_brackets += +$('#cond_ob_' + num).val();
                close_brackets += +$('#cond_cb_' + num).val();
                if (close_brackets && !open_brackets) break;
            }
        }
        if (open_brackets != close_brackets) {
            return false;
        } else {
            return true;
        }
    }

    $(function () {
        var last_num = 0;
        {foreach from=$cond_set item=cond key=num}
        add_cond({$num}, {$cond.field}, '{$cond.term}', '{$cond.value|replace:"'":"\'"}', '{$cond.value_link}', '{$cond.oper}', '{$cond.interval}', '{$cond.period}', '{$cond.union}', '{$cond.open_bracket}', '{$cond.close_bracket}');
        {foreachelse}
        add_cond(1);
        {/foreach}
        {if $mode=="wizard"}set_expert(true);{/if}
    });

    // Создаем пременные цветов кнопок
    {foreach from=$buttonColors key=one_name item=one_color}
        var color_{$one_name} = '{$one_color}';
    {/foreach}

    // Функция изменения цвета кнопки при изменении значения в списке
    function changeСolor(colorSelect) {
        const curOptTxtColor = $(colorSelect).val();
        const curOptFontColor = $(colorSelect).find('option[value="' + curOptTxtColor + '"]').attr('txt-color');
        const bgColorVal = $('#input_bg_color');
        const txtColorVal = $('#input_txt_color');
        const fontColorVal = $('#input_font_color');
        const formatExample = $('#example_text');
        const formatTxtExample = $('#example_text span');
        const exampleTxtColor = curOptTxtColor !== 'null' ? this['color_' + curOptTxtColor] : '';
        const exampleFontColor = curOptTxtColor !== 'null' ? curOptFontColor : '';
        const txtExample = $('#text_style').prop('checked');

        formatExample.css('color', exampleFontColor);
        fontColorVal.val(exampleFontColor);

        if (txtExample) {
            formatExample.css('background-color', '');
            formatTxtExample.css('background-color', exampleTxtColor);
            bgColorVal.val('');
            txtColorVal.val(exampleTxtColor);
        } else {
            formatExample.css('background-color', exampleTxtColor);
            formatTxtExample.css('background-color', '');
            bgColorVal.val(exampleTxtColor);
            txtColorVal.val('');
        }
    }

    // Функция show/hide режима редактироваия цвета
    function changeColorMode() {
        const standartMode = $('#color-standart');
        const paletteMode = $('#color-palette');
        const standartModeBtn = $('#standart-mode');
        const paletteModeBtn = $('#palette-mode');
        const select = $('#select-colors');

        if (standartModeBtn.attr('checked')) {
            const hiddenValBg = $('#palette_bg').val();
            const hiddenValTxt = $('#palette_txt').val();
            const hiddenValFont = $('#palette_font').val();
            const bgColorVal = $('#input_bg_color');
            const txtColorVal = $('#input_txt_color');
            const fontColorVal = $('#input_font_color');
            const formatExample = $('#example_text');
            const formatTxtExample = $('#example_text span');

            paletteMode.show();
            standartMode.hide();
            paletteModeBtn.attr('checked', true);
            standartModeBtn.removeAttr('checked');
            bgColorVal.val(hiddenValBg);
            txtColorVal.val(hiddenValTxt);
            fontColorVal.val(hiddenValFont);
            formatExample.css('background-color', hiddenValBg);
            formatExample.css('color', hiddenValFont);
            formatTxtExample.css('background-color', hiddenValTxt);
            $('#text_style').hide();
            $('#text_style-name').hide();
        } else {
            changeСolor(select);
            standartMode.show();
            paletteMode.hide();
            standartModeBtn.attr('checked', true);
            paletteModeBtn.removeAttr('checked');
            $('#text_style').css('display', '');
            $('#text_style-name').css('display', '');
        }
    }

    function changeFieldSettings(field) {
        const value = $(field).val();
        const id = $(field).attr('id');
        const cellCheckbox = $('#text_style');
        const textStyleSetting = cellCheckbox.prop('checked');


        if(id.indexOf('chosen') === -1){
            if (value == '0' || !value) {
                if (!textStyleSetting) switch_style();
            } else if (textStyleSetting) switch_style();
        }
    }
</script>
<br>
<div align=center>
    {if $no_save_mode}<img src="images/lock.svg" style="width:20px; padding-right:5px;" title="{$lang.Element_no_edit_msg}">{/if}
    {if $format_id eq -1}{$lang.Create_format}{else}{$lang.Edit_format} "{$name}"{/if} {$lang.of_table} "{$name_table}"
    {if $format_id != -1 && !$blocked}
        <div style="left: 10px; top: 2px; float: none;"
            onclick="switchOnObject('{$format_id}')"
            class="switch-btn {if !$disabled}switch-on{/if}"
            id="switch-on-btn_{$format_id}"></div>
        <script>
            let ajaxObj = new XMLHTTP("edit_format.php");
            ajaxObj.format = 0;
            ajaxObj.method = "POST";
            function switchOnObject(format_id) {
                $('#switch-on-btn_'+format_id).toggleClass('switch-on');
                $('#switch-on-btn_'+format_id).trigger('on.switch');
                ajaxObj.call('format_id='+format_id+'&sel=disable&enbl='+($('#switch-on-btn_'+format_id).hasClass('switch-on')?1:0)+'&csrf={$csrf}',()=>{});
            }
        </script>
    {/if}
</div>
<br>
{if $message}
    <div style="text-align:center;font-size: 13px;">
        <span id="edit_config__info-maessage" style="color:green">{$message}</span><br><br>
    </div>
{/if}
{if $error}
    <div style="text-align:center;font-size: 13px;">
        <span id="edit_config__info-maessage" style="color:red">{$error}</span><br><br>
    </div>
{/if}
{if $blocked}
    <div style="text-align:center;font-size: 13px;">
        <a href="edit_format.php?table={$table_id}">{$lang.Return}</a>
    </div>
{else}
<form action="edit_format.php?table={$table_id}&format={$format_id}" method=post id="format_form">
    <input type=hidden name=back_url value="{$base64_back_url}">
    <input type=hidden name=csrf value="{$csrf}">
    <table border=0 cellpadding=3>
        <tr>
            <td align=right width=130>{$lang.Name}<span class='help_bt' h_id='Name'></span>:</td>
            <td><input class='form-control form-control-160' type=text size=50 name="name" id="name" value="{$name}"></td>
        </tr>
        <tr>
            <td></td>
        </tr>

        <tr id="wizard_mode" {if $mode=="expert"}style="display:none"{/if}>
            <td align=right>{$lang.Condition}<span class='help_bt' h_id='Conditions'></span>:</td>
            <td id="wizard_set"></td>
        </tr>
        <tr id="expert_mode" {if $mode=="wizard"}style="display:none"{/if}>
            <td align=right>{$lang.Condition}<span class='help_bt' h_id='Conditions'></span>:</td>
            <td><textarea class='form-control' name="cond_value" id="condition" cols=100 rows=5
                        {if $user.group_id!=1}readonly="1"{/if}>{$cond_value}</textarea></td>
        </tr>

        <tr class="format-field">
            <td align=right>{$lang.Format}<span class='help_bt' h_id='Format'></span>:</td>
            <td>
                <table cellpadding=0 cellspacing=0>
                    <tr>
                        <td><select class='form-control form-control-250' name="target" id="format_target" onchange="changeFieldSettings(this);">{$sel_target}</select></td>
                        <td style="padding-left:20px"><input type=checkbox id="b_style"
                                                             {if $font_style[0]==1}checked{/if} onclick="switch_style();">
                        </td>
                        <td><b title="{$lang.bold}">B</b></td>
                        <td style="padding-left:10px"><input type=checkbox id="i_style"
                                                             {if $font_style[1]==1}checked{/if} onclick="switch_style();">
                        </td>
                        <td><i title="{$lang.italic}">I</i></td>
                        <td style="padding-left:10px"><input type=checkbox id="u_style"
                                                             {if $font_style[2]==1}checked{/if} onclick="switch_style();">
                        </td>
                        <td><u title="{$lang.underline}">U</u></td>
                        <td style="padding-left:10px"><input type=checkbox id="s_style"
                                                             {if $font_style[3]==1}checked{/if} onclick="switch_style();">
                        </td>
                        <td><s title="{$lang.strikethrough}">S</s></td>
                        <td class="hidden">
                            <input type=checkbox id="text_style" {if $font_style[4]==1}checked{/if} onclick="switch_style();">
                        </td>

                        <td style="padding-left:40px">
                            <div id="example_text"
                                style="padding:5px;{if $example_style}{$example_style}{/if}{if $bg_color} background-color:{$bg_color};{/if}{if $font_color} color:{$font_color};{else}{if $format_id eq -1} color:#4b4b4b;{/if}{/if}">
                                <span style="{if $txt_color}background-color:{$txt_color};{else}{if $format_id eq -1} background-color:#ededed;{/if}{/if}">{$lang.Sample}</span>
                            </div>
                        </td>
                        <script>
                            function switch_style() {
                                let font_style = '';
                                let exampleText = $('#example_text');
                                const bgColorVal = $('#input_bg_color');
                                const txtColorVal = $('#input_txt_color');
                                const fontColorVal = $('#input_font_color');
                                const bChecked = $('#b_style').prop('checked');
                                const iChecked = $('#i_style').prop('checked');
                                const uChecked = $('#u_style').prop('checked');
                                const sChecked = $('#s_style').prop('checked');
                                const textChecked = $('#text_style').prop('checked');
                                const curColorVal = $('#select-colors').val();
                                const bgColor = this['color_' + curColorVal];

                                if (bChecked) font_style += '1'; else font_style += '0';
                                if (iChecked) font_style += '1'; else font_style += '0';
                                if (uChecked) font_style += '1'; else font_style += '0';
                                if (sChecked) font_style += '1'; else font_style += '0';
                                if (textChecked) font_style += '1'; else font_style += '0';
                                $('#input_font_style').val(font_style);

                                if (bChecked) exampleText.css('font-weight', 'bold');
                                else exampleText.css('font-weight', 'normal');

                                if (iChecked) exampleText.css('font-style', 'italic');
                                else exampleText.css('font-style', 'normal');

                                {* if (textChecked) {
                                    exampleText.css('background-color', bgColor);
                                    exampleText.find('span').css('background-color', '');
                                    bgColorVal.val(bgColor);
                                    txtColorVal.val('');
                                } else {
                                    exampleText.css('background-color', '');
                                    exampleText.find('span').css('background-color', bgColor);
                                    bgColorVal.val('');
                                    txtColorVal.val(bgColor);
                                } *}

                                if (uChecked && !sChecked) exampleText.css('text-decoration', 'underline');
                                else if (!uChecked && sChecked) exampleText.css('text-decoration', 'line-through');
                                else if (uChecked && sChecked) exampleText.css('text-decoration', 'underline line-through');
                                else exampleText.css('text-decoration', 'none');
                            }
                        </script>
                    </tr>
                </table>
            </td>
        </tr>
        <tr>
            <td></td>
        </tr>

        <!-- Выбор цвета из готовых комбинаций -->
        <tr class="format-font-color" id="color-standart" {if $color_mode}style="display: none;"{/if}>
            <td align="right">{$lang.Color_scheme}<span class="help_bt" h_id="Format_color_set"></span>:</td>
            <td>
                <table>
                    <tbody>
                        <tr>
                            <td>
                                <select class="form-control form-control-160" id="select-colors"
                                        onchange="changeСolor(this);">
                                            {$color_options}
                                </select>
                            </td>
                        </tr>
                    </tbody>
                </table>
            </td>
        </tr>

        <!-- Выбор цвета с помощью колопикеров -->
        <tr id="color-palette" {if !$color_mode}style="display: none;"{/if}>
            <td align="right">{$lang.Font_color}<span class="help_bt" h_id="Format_font_color"></span>:</td>
            <td>
                <table>
                    <tr>
                        <td>
                            <input type="text" id="font_color" class="colorSelector" value="{if $font_color}{$font_color}{else}{/if}">
                        </td>
                        <td style="padding-left:20px">{$lang.Background_color}<span class="help_bt" h_id="Format_bg_color"></span>:</td>
                        <td>
                            <input type="text" id="bg_color" class="colorSelector" value="{if $bg_color}{$bg_color}{else}{/if}">
                        </td>
                        <td style="padding-left:20px">{$lang.Txt_color}<span class="help_bt" h_id="Format_txt_color"></span>:</td>
                        <td>
                            <input type="text" id="txt_color" class="colorSelector" value="{if $txt_color}{$txt_color}{else}{/if}">
                        </td>
                    </tr>
                </table>
                <input type='hidden' id='palette_bg' value='{if $bg_color}{$bg_color}{/if}'>
                <input type='hidden' id='palette_txt' value='{if $txt_color}{$txt_color}{/if}'>
                <input type='hidden' id='palette_font' value='{if $font_color}{$font_color}{/if}'>
            </td>

            <script>
                // Функция работы палитры
                $('.colorSelector').each(function (i, item) {
                    colorpickerSetings.change = function(color) {
                        var hex = '';
                        if (color) {
                            hex = color.toHexString();
                        }

                        if (hex) {
                            const hiddenValBg = $('#palette_bg');
                            const hiddenValTxt = $('#palette_txt');
                            const hiddenValFont = $('#palette_font');

                            $(item).css('background-color', hex);
                            $('#input_' + $(item).attr('id')).val(hex);
                            if (item.id == 'bg_color') {
                                $('#example_text').css('background-color', hex);
                                hiddenValBg.val(hex);
                            }
                            if (item.id == 'txt_color') {
                                $('#example_text span').css('background-color', hex);
                                hiddenValTxt.val(hex);
                            }
                            if (item.id == 'font_color') {
                                $('#example_text').css('color', hex);
                                hiddenValFont.val(hex);
                            }
                        }
                    };

                    colorpickerSetings.show = function() {
                        $('.sp-clear.sp-clear-display').each(function (btnIndex, btn) {
                            clearBtn = $(btn);
                            let hiddenInputForDataText = $('#input_txt_color');
                            let hiddenInputForDataBg = $('#input_bg_color');
                            let hiddenInputForDataFont = $('#input_font_color');
                            let exampleTxt = $('#example_text span');
                            let exampleTxtParentBlock = $('#example_text');

                            clearBtn.on('click', function(e) {
                                const activePicker = $('.sp-replacer.sp-light.sp-active');
                                const hiddenValBg = $('#palette_bg');
                                const hiddenValTxt = $('#palette_txt');
                                const hiddenValFont = $('#palette_font');

                                if (activePicker.prev().attr('id') === 'bg_color') {
                                    hiddenInputForDataBg.val('');
                                    exampleTxtParentBlock.css('background-color', '');
                                    hiddenValBg.val('');
                                }
                                if (activePicker.prev().attr('id') === 'txt_color') {
                                    hiddenInputForDataText.val('');
                                    exampleTxt.css('background-color', '');
                                    hiddenValTxt.val('');
                                }
                                if (activePicker.prev().attr('id') === 'font_color') {
                                    hiddenInputForDataFont.val('');
                                    exampleTxt.css('color', '');
                                    hiddenValFont.val('');
                                }
                            });
                        });
                    };

                    colorpickerSetings.clearText = lang.Reset;
                    colorpickerSetings.allowEmpty = true;

                    $(this).spectrum(colorpickerSetings);
                });
            </script>
        </tr>

        <input type='hidden' id='input_font_style' name='font_style' value='{$font_style}'>
        <input type='hidden' id='input_font_color' name='font_color' value='{if $font_color}{$font_color}{else}{if $format_id eq -1}#4b4b4b{/if}{/if}'>
        <input type='hidden' id='input_bg_color' name='bg_color' value='{if $bg_color}{$bg_color}{/if}'>
        <input type='hidden' id='input_txt_color' name='txt_color' value='{if $txt_color}{$txt_color}{else}{if $format_id eq -1}#ededed{/if}{/if}'>

        <tr>
            <td></td>
        </tr>
        <tr>
            <td></td>
            <td>
                <a href="" id="open_add_set" style="width: 110px;display: inline-block">{$lang.Additional}</a>
                {if $config.protect_of_elements && $user.id == 1}<a href="" id="protect_switch" style="width: 60px;display: inline-block">{$lang.Protect}</a>{/if}
                <a href="fields.php?table={$table_id}" target="_blank">{$lang.view_table}</a>
                {if $format_id > 0}<a href="edit_log.php?st_date=00&f_text=edit_format.php?table%3D{$table_id}%26format%3D{$format_id}>" target="_blank" style="padding-left:10px">{$lang.Log}</a>{/if}
            </td>
        </tr>
        <tbody id="additional_settings" style="{if !$display_add_set}display:none{/if}">
            <tr>
                <td></td>
            </tr>
            <tr>
                <td align=right>{$lang.Condition_mode}<span class='help_bt' h_id='Conditions'></span>:</td>
                <td style="padding-left:6px;">
                    <label class="radio-inline">
                        <input type="radio" name="mode" value="wizard" class="format__cond-input" enabled {if $mode=="wizard"}checked{/if} {if $mode=="expert"}disabled{/if} style="margin-top: 3px"
                            onclick="document.getElementById('wizard_mode').style.display=''; document.getElementById('expert_mode').style.display='none';">{$lang.wizard_mode}
                    </label>
                    <label class="radio-inline">
                        <input type="radio" name="mode" value="expert" class="format__cond-input" {if $mode=="expert"}checked{/if} style="margin-top: 3px"
                            onclick="document.getElementById('expert_mode').style.display=''; document.getElementById('wizard_mode').style.display='none';"
                           {if !$all_modules.pro_tariff && $mode != "expert"}disabled title="{$lang.Pro_tariff_func_message}"{/if}><span 
                           {if !$all_modules.pro_tariff && $mode != "expert"}style="color: #999;"{/if}>{$lang.expert_mode}</span>
                    </label>
                </td>
            </tr>
            <tr>
                <td align=right>{$lang.Color_mode}<span class='help_bt' h_id='Format_color_mode'></span>:</td>
                <td style="padding-left:6px;">
                    <label class="radio-inline">
                        <input type="radio" id="standart-mode" onchange="changeColorMode()" style="margin-top: 3px"
                            name="color_mode" value="0" {if !$color_mode}checked{/if}>{$lang.wizard_mode}
                    </label>
                    <label class="radio-inline">
                        <input type="radio" id="palette-mode" onchange="changeColorMode()" style="margin-top: 3px"
                            name="color_mode" value="1" {if $color_mode}checked{/if}
                           {if !$all_modules.pro_tariff && !$color_mode}disabled title="{$lang.Pro_tariff_func_message}"{/if}><span 
                           {if !$all_modules.pro_tariff && !$color_mode}style="color: #999;"{/if}>{$lang.expert_mode}</span>
                    </label>
                </td>
            </tr>
            <tr>
                <td align=right>{$lang.Help_with_formatting}<span class='help_bt' h_id='Help_with_formatting'></span>:</td>
                <td><textarea class='form-control   ' name="help" rows=5 cols=38>{$help}</textarea></td>
            </tr>
        </tbody>
        {if $config.protect_of_elements && $user.id == 1}
        <tbody id="protect_block" style="display:none">
            <tr>
                <td align="right">{$lang.Protected}<span class='help_bt' h_id='Protect_of_element'></span>:</td>
                <td>
                    <input type="checkbox" name="protected" {if $protected}checked{/if} onclick="$('[id^=pr_]').prop('disabled', !this.checked)">
                    <span class="access_param_wrapper">{$lang.View2}<span class='help_bt' h_id='protect_of_view'></span></span>
                    <span class="access_param_wrapper">{$lang.Edit3}<span class='help_bt' h_id='protect_of_edit'></span></span>
                </td>
            </tr>
            <tr>
                <td align="right"></td>
                <td>
                    <div style="float: left; margin:0 34px; width: 60px; padding: 8px 0 6px 15px; text-align: center;">
                        <input type="checkbox" id="pr_view_all" {if !$protected}disabled{/if}
                               onclick="$('[id^=pr_view]').prop('checked', this.checked); if (!this.checked) $('[id^=pr_edit]').prop('checked', 0);">
                    </div>
                    <div style="float: left; margin:0 34px; width: 60px; padding: 8px 0 6px 0; text-align: center;">
                        <input type="checkbox" id="pr_edit_all" {if !$protected}disabled{/if}
                               onclick="$('[id^=pr_edit]').prop('checked', this.checked); if ( this.checked) $('[id^=pr_view]').prop('checked', 1);">
                    </div>
                </td>
            </tr>
            {foreach from=$protect key=gid item=acc}
                <tr>
                    <td align="right" style="padding-top: 11px;">{$acc.name}:</td>
                    <td style="display: flex; flex-wrap: nowrap;">
                        <div style="float: left; margin:0 34px; width: 60px; padding: 8px 0 6px 15px; text-align: center;">
                            <input type="checkbox" name="protect_rights[{$gid}][view]" id="pr_view{$gid}" value="1"
                                   {if $acc.view}checked{/if} {if !$protected}disabled{/if}
                                   onclick="if (!this.checked) $('#pr_edit{$gid}').prop('checked', 0)">
                        </div>
                        <div style="float: left; margin:0 34px; width: 60px; padding: 8px 0 6px 0; text-align: center;">
                            <input type="checkbox" name="protect_rights[{$gid}][edit]" id="pr_edit{$gid}" value="1"
                                   {if $acc.edit}checked{/if} {if !$protected}disabled{/if}
                                   onclick="if ( this.checked) $('#pr_view{$gid}').prop('checked', 1)">
                        </div>
                    </td>
                </tr>
            {/foreach}
            <tr><td></td></tr>
            <tr>
                <td align=right>{$lang.Comment}<span class='help_bt' h_id='protect_comment'></span>:</td>
                <td><textarea class="form-control form-control-250" name="protect_comment" rows=5>{$protect_comment}</textarea></td>
            </tr>
        </tbody>
        {/if}
        <tr>
            <td colspan="4" align="center"><br>
                <input class="btn btn-default btn-sm" type=submit name="save" value="{$lang.Save}"
                       onClick="link_fields_in_condition();fill_autocompletes();if (!document.getElementById('name').value.replace(/ /g,'') || !document.getElementById('condition').value.replace(/ /g,'')) { jalert('{$lang.Please_enter_format_name}');return false; } else if (!check_brackets()) { jalert('{$lang.Incorrect_brackets_alert}'); return false; } "
                       {if $no_save_mode}disabled title="{$lang.Element_no_edit_msg}"{/if}>
                <br>
                <br>
                <a href="edit_format.php?table={$table_id}">{$lang.Return}</a>
            </td>
        </tr>
    </table>
</form>
{/if}
<script>
    function fill_autocompletes() {
        var autocompletes = $('.autocomplete__input');
        autocompletes.each(function() {
            if ($(this).val() === '') {
                $(this).parent().prev().append('<option value="0" selected></option>');
            }
        });
    }
</script>
<script src="include/js/configuration.js?{$revision}"></script>
<div style="height:150px"></div>
