import Model from '../model';
import {drawNoAccess, getUrlVars, renderPage, URL} from '../util';
import EditView from './edit-view';
import {IEdit} from './edit';
import App from '../app';
import Access from '../access';
import View from '../view';
import AutoComplete from '../autocomplete';

declare const require: any;

const form2js = require(`form2js`);

interface ResponseItem {
    Label: string;
    Value: string;
}

enum EventType {
    KEYDOWN,
    KEYUP
}

const initLinks = (): void => {
    new AutoComplete({
        EmptyMessage: `Нет записей`,
        QueryArg: `link_text`
    });
};

export default class EditController {
    private editModel: Model;
    private lineId: number;

    public init(data: {
        lineId: number
    } = {
        lineId: 0
    }): void {
        this.lineId = data.lineId;
        this.editModel = new Model();
        this.editModel.getData(`${URL}?edit=${data.lineId}`)
            .then((response: {
                lines: Array<IEdit>
            }): void => {
                Access.setAccess(response as any);
                if (this.lineId == 0 && Access.add === 1 || this.lineId != 0 && Access.edit === 1) {
                    const editView: EditView = new EditView(response.lines, this.lineId);
                    renderPage(editView);
                } else {
                    const text = (this.lineId == 0) ?
                        `Нет доступа на добавления записи` :
                        `Нет доступа на редактирование записи`;
                    const view = new class extends View {
                        protected get template(): string {
                            return drawNoAccess(text);
                        }
                    };
                    renderPage(view);
                }
                this.bind();

            })
            .catch((err: Error): void => {
                throw new Error(`Error with binding edit line, ${err}`);
            });

    }

    private bind = (bind: boolean = true): void => {
        const backBtn: HTMLButtonElement = document.querySelector(`#back-btn`);

        if (backBtn) {
            if (bind) {
                backBtn.addEventListener(`click`, this.onBackClick);
            } else {
                backBtn.removeEventListener(`click`, this.onBackClick);
            }
        }

        const saveBtn: HTMLButtonElement = document.querySelector(`#save-btn`);

        if (saveBtn) {
            if (bind) {
                saveBtn.addEventListener(`click`, this.onSaveClick)
            } else {
                saveBtn.removeEventListener(`click`, this.onSaveClick)
            }
        }

        const deleteBtn: HTMLButtonElement = document.querySelector(`#delete-btn`);

        if (deleteBtn) {
            if (bind) {
                deleteBtn.addEventListener(`click`, this.onDeleteClick);
            } else {
                deleteBtn.removeEventListener(`click`, this.onDeleteClick);
            }
        }

        initLinks();
    };

    private onDeleteClick = () => {
        this.bind(false);
        this.editModel.deleteLine(`${URL}?delete=${this.lineId}`)
            .then(() => {
                App.showTable({
                    pagination: parseInt(getUrlVars()[`pagination`]) || 0,
                    search: getUrlVars()[`search`] || ``
                });
            })
    };

    private onSaveClick = () => {
        const lineForm: HTMLFormElement = document.querySelector(`#edit-form`);

        if (lineForm) {
            this.bind(false);
            const _form2js = form2js.form2js;
            const form: {
                [name: string]: string
            } = _form2js(`edit-form`, `.`, false);
            const url = (this.lineId != 0) ? `${URL}?edit_line=${this.lineId}` : `${URL}?add_line=1`;
            this.editModel.setData(url, JSON.stringify(form))
                .then((res: number = 0): void => {
                    App.showLine({
                        id: res
                    });
                })
                .catch((err: Error): void => {
                    throw new Error(`Error with showing view line, ${err}`);
                });
        }
    };

    private onBackClick = () => {
        this.bind(false);
        if (this.lineId != 0) {
            App.showLine({
                id: this.lineId
            });
        } else {
            App.showTable({
                pagination: parseInt(getUrlVars()[`pagination`]) || 0,
                search: getUrlVars()[`search`] || ``
            });
        }
    };
}