const fields = {    
      
    "apps": {

        "auth_client_id": {
            "type": "input-text",
            "default": "",
            "required": true,
            "help": "diadoc_client_id"         
        },

        "auth_client_secret": {
            "type": "input-text",
            "default": "",
            "required": true,
            "help": "diadoc_client_secret"         
        },
        
        "__oauth_button": {
            "type": "html"
        }     
        
    },

//Сопоставление таблиц КБ и объектов внешнего приложения    
    "tables": {

        "name": {
            "type": "input-text",
            "default": "",
            "required": true,
            "help": "diadoc_table_name",
        },

        "external_object_type": {
            "type": "dropdown",
            "optionsFrom": {
                source: "options",
                field: "external_object_type"
            },
            "help": "diadoc_external_object",
            "required": true
        },

        "internal_object_id": {
            "type": "dropdown",
            "optionsFrom": {
                source: "tables"
            },
            "required": true,
            "help": "diadoc_internal_object"
        }
    },

    "connectors": {



        "name": {
            "type": "input-text",
            "default": "",
            "required": true,
            "help": "diadoc_connector_name",
        },

        "internal_action": {
            "type": "dropdown",
            "options": {
                "none": "Ничего не делать",
                "create": "Создать запись",
                "update": "Обновить запись",
                "updatecreate": "Обновить запись или создать новую",
                "updateself": "Обновить отправленную запись",
                "delete": "Удалить запись"
            },
            "default": "none",
            "required": true,
            "help": "diadoc_internal_action"
        },   
        
        "object_mapping_id": {
            "type": "dropdown",
            "optionsFrom": {
                source: "list",
                field: "tables",
                value: "id",
                label: "name"
            },
            "required": true,
            "help": "diadoc_table"
        },        


        "external_action": {
            "type": "dropdown",
            "optionsFrom": {
                source: "options",
                field: "object_mapping_id",
                optionsDir: "actions",
                from_list: "tables",
                from_list_options: "external_object_type"
            },
            "required": true,
            "help": "diadoc_external_action"
        },        

        calc: {
            type: "html",
        },

        cron: {
            type: "html",
        },

        button: {
            type: "html",
        }        
    },

    "own_rules_fields": {
        "type": "radiobutton",
        "options": {
            "no": "default_rules",
            "yes": "own_rules"
        }, 
    },

    "rules_file": {
        "type": "input-text",
        "default": "",
        "required": true,
        "help": "diadoc_rules_file",
    },    

    "rules_docid": {
        "type": "input-text",
        "default": "",
        "required": true,
        "help": "diadoc_rules_docid",
    },    
    
    "rules_messageid": {
        "type": "input-text",
        "default": "",
        "required": true,
        "help": "diadoc_rules_message",
    },      

    "rules_status": {
        "type": "input-text",
        "default": "",
        "required": true,
        "help": "diadoc_rules_status",
    },    

    "rules_our_company": {
        "type": "input-text",
        "default": "",
        "required": true,
        "help": "diadoc_rules_our_company",
    },      

    "rules_recipient": {
        "type": "input-text",
        "default": "",
        "required": true,
        "help": "diadoc_rules_recipient",
    },     
    
    "rules_inn": {
        "type": "input-text",
        "default": "",
        "required": true,
        "help": "diadoc_rules_inn",
    },      

    "rules_kpp": {
        "type": "input-text",
        "default": "",
        "required": true,
        "help": "diadoc_rules_kp",
    },      



    "own_rules_status": {
        "type": "radiobutton",
        "options": {
            "no": "default_rules",
            "yes": "own_rules"
        }, 
    },    

    "rules_statuses": {
        "type": "input-textarea",
        "default": "",
        "required": true,
        "help": "diadoc_rules_statuses",
    },

    "rules_cronperiod": {
        "type": "input-text",
        "default": "",
        "required": true,
        "help": "diadoc_rules_cronperiod",
    },    


    "own_rules_names": {
        "type": "radiobutton",
        "options": {
            "no": "default_rules",
            "yes": "own_rules"
        }, 
    }, 
    

    "rules_buttonname": {
        "type": "input-text",
        "default": "",
        "required": true,
        "help": "diadoc_rules_buttonname",
    },    



}

export default fields;