const fields = {

    "table-text-check_on": {
        "type": "input-text",
        "size": "medium",
        "default": "",
    },
    
    "table-text-check_fail": {
        "type": "input-text",
        "size": "medium",
        "default": "",
    },
    "api-url": {
        "type": "dropdown",
        "size": "medium",
        "options": {
            "https://alfa.rbsuat.com" : "Тестовый",
            "https://pay.alfabank.ru": "pay.alfabank.ru",
            "https://payment.alfabank.ru": "payment.alfabank.ru",
            "https://ecom.alfabank.ru": "ecom.alfabank.ru",
        },
        "required": true
    },
    "token": {
        "type": "input-text",
        "size": "medium",
        "default": "",
    },

    "test-link": {
        "type": "link"
    },

    "table-list": {
        "target-table": {
            "type": "dropdown",
            "size": "medium",
            "optionsFrom": {
                "source": "tables"
            },
            "required": true
        },
       
        "table-payment-summ": {
            "type": "dropdown",
            "size": "medium",
            "optionsFrom": {
                "source": "fields",
                "parent": "target-table",
                "fieldsType": "number"
            },
            "required": true
        },
        "table-payment-description": {
            "type": "dropdown",
            "size": "medium",
            "optionsFrom": {
               "source": "fields",
               "parent": "target-table",
               "fieldsType": "text"
            },
            "required": true
        },
        "table-paid-amount": {
            "type": "dropdown",
            "size": "medium",
            "optionsFrom": {
               "source": "fields",
               "parent": "target-table",
               "fieldsType": "number"
            },
            "required": true
        },
        "table-payment-date": {
            "type": "dropdown",
            "size": "medium",
            "optionsFrom": {
               "source": "fields",
               "parent": "target-table",
               "fieldsType": "date"
            },
            "required": true
        },
        "table-payment-status": {
            "type": "dropdown",
            "size": "medium",
            "optionsFrom": {
               "source": "fields",
               "parent": "target-table",
               "fieldsType": "list"
            },
            "required": true
        },
        "table-payment-lifetime": {
            "type": "dropdown",
            "size": "medium",
            "options": {
                0: "indefinitely",
                24: "1 day",
                72: "3 days",
                336: "14 days",
                720: "30 days",
                2160: "90 days",
            },
            "required": true
        },
        "table-payment-lifetime-date": {
            "type": "dropdown",
            "size": "medium",
            "optionsFrom": {
               "source": "fields",
               "parent": "target-table",
               "fieldsType": "date"
            },
            "required": true
        },
        "table-automatic-link-generation": {
            "type": "checkbox",
        },
        "table-data-for-generating-check-in-online-cash-desk": {
            "type": "checkbox",
        },
        "table-payment-taxation": {
            "type": "dropdown",
            "size": "medium",
            "options": {
                "osn": "osn",
                "usn_income": "usn_income",
                "usn_income_outcome": "usn_income_outcome",
                "patent": "patent",
                "envd": "envd",
                "esn": "esn",
            },
            "required": true
        },
        "table-email-for-check": {
            "type": "dropdown",
            "size": "medium",
            "optionsFrom": {
                "source": "fields",
                "parent": "target-table",
                "fieldsType": "text"
            },
            "required": true
        },
        "table-subtable": {
            "type": "dropdown",
            "size": "medium",
            "optionsFrom": {
               "source": "subtables",
               "parent": "target-table",
            },
            "required": true
        },
        "table-product-number": {
            "type": "dropdown",
            "size": "medium",
            "optionsFrom": {
               "source": "fields",
               "parent": "table-subtable",
               "fieldsType": "number"
            },
            "required": true
        },
        "table-product-name": {
            "type": "dropdown",
            "size": "medium",
            "optionsFrom": {
               "source": "fields",
               "parent": "table-subtable",
            },
            "required": true
        },
        "table-product-vendor": {
            "type": "dropdown",
            "size": "medium",
            "optionsFrom": {
               "source": "fields",
               "parent": "table-subtable",
            },
            "required": true
        },
        "table-product-quantity": {
            "type": "dropdown",
            "size": "medium",
            "optionsFrom": {
               "source": "fields",
               "parent": "table-subtable",
               "fieldsType": "number"
            },
            "required": true
        },
        "table-subtable-measure": {
            "type": "dropdown",
            "size": "medium",
            "optionsFrom": {
               "source": "tables"
            },
            "required": true
        },
        "table-measure-key": {
            "type": "dropdown",
            "size": "medium",
            "optionsFrom": {
               "source": "fields",
               "parent": "table-subtable-measure",
            },
            "required": true
        },
        "table-product-measure": {
            "type": "dropdown",
            "size": "medium",
            "optionsFrom": {
               "source": "fields",
               "parent": "table-subtable",
            },
            "required": true
        },
        "table-product-price": {
            "type": "dropdown",
            "size": "medium",
            "optionsFrom": {
               "source": "fields",
               "parent": "table-subtable",
               "fieldsType": "number"
            },
            "required": true
        },
        "table-product-vat": {
            "type": "dropdown",
            "size": "medium",
            "optionsFrom": {
               "source": "fields",
               "parent": "table-subtable",
               "fieldsType": "list"
            },
            "required": true
        },
    },

    "checkbox-groups": {
        "type": "checkbox",
        "optionsFrom": {
            "source": "groups"
        }
    }

}

export default fields;
