import useScopedStyleMixin from '../../useScopedStyleMixin.js'
import SwitcherStyles from './SwitcherStyles.js'

const Switcher = {
  props: {
    value: {
      type: Boolean,
      default: false
    },
    index: Number,
  },
  template: `
    <div :class="componentClass + hash" @click="toggleSwitch">
      <div :class="[componentClass + hash + '__track', { 'active': isActive }]">
        <div :class="[componentClass + hash + '__circle', { 'active': isActive }]"></div>
      </div>
    </div>
  `,
  data() {
    return {
      isActive: this.value,
      componentClass: 'activity-switch',
    };
  },
  watch: {
    value(newValue) {
      this.isActive = newValue;
    }
  },
  name: 'activity-switch',
  mixins: [useScopedStyleMixin, SwitcherStyles],
  methods: {
    toggleSwitch(e) {
      e.preventDefault();
      this.isActive = !this.isActive;
      this.$emit('update', this.index, this.isActive, e);
    },
  },
};

export default Switcher;