import useKOSearchBlockStore from "./../store/index.js";


/** Компонент представления заголовка блока */
export const CaptionComponent = {
  props: ['block_name'],

  setup(props, {emit}) {
    const store = useKOSearchBlockStore();

    return {
      store,

      buildCheckboxIdent() {
        return `checkbox_${store.block_name}`;
      },

      clickHandle() {
        toggleCollapseEntity(store.report_id, store.block_name);
      }
    }
  },

  template: /*html*/`
    <input :id="buildCheckboxIdent()" type="checkbox" class="caption_checkbox">
    <label :for="buildCheckboxIdent()" @click="clickHandle">
      {{ store.caption }}
    </label>
  `
}
