import createKanbanBlock from './kanban/index.js';
import createSearchBlock from './SearchBlock/index.js';

/**
 * В пространство имен CB.report добаляю блоки
 */
if (
  typeof CB !== 'undefined' &&
  typeof CB.report !== 'undefined'
) {
  CB.report = {
    store: {
      items: new Array(),

      // добавляю настройки vue приложения
      set(item) {
        // если нет данных, то добавляю
        if (this.items.filter((value) => value.ident == item.ident).length == 0) {
          this.items.push(item);
        }

        // если есть, то обновляю настройки
        else {
          this.items = this.items.filter((value) => value.ident != item.ident);
          this.items.push(item);
        }

        // запускаю событие инициализации vue приложения
        CB.pubsub.publish('report-constructor/initialization', item);
      }
    },

    ...CB.report,

    ...{
      createKanbanBlock,
      createSearchBlock,
    }
  }
}
