/**
 * Компонент строка ввода для стены
 */
import { ulid } from '../../lib/ulid.js';
import useWallStore from './store.js';

const template = /*html*/`
<div class="cbv-wall-input">
  <input type="text" v-model="value" @keyup.enter="addNewItem()"></input>
</div>
`;

export default {
  template,
  setup(props) {
    const value = Vue.toRef(props,'value');
    const store = useWallStore();
    const addNewItem = () => {
      let val = value.value && value.value.trim();
      if (!val) return;
      let item = {
          id: ulid(),
          body: val,
      };
      store.addItem(item);
      value.value = '';
    }
    return {
      value,
      addNewItem,
    }
  },
}

CB.styles.globed(/*css*/`
.cbv-wall-input > input {
  font-size: 18px;
  width: 100%;
  margin: 1rem 0 3rem 0;
}
`);
