/**
 * Компонент вывода стенания
 */
import { decodeTime } from '../../lib/ulid.js';
import useWallStore from './store.js';

const template = /*html*/`
<div class="cbv-wall-item">
  <div class="cbv-wall-item--id">{{datestr(item.id)}}</div>
  <div class="cbv-wall-item--body">
    {{item.body}}
    <span class="cbv-wall-item--deleter" @click="remove(item.id)">x</span>
  </div>
</div>
`;

export default {
  template,
  props: {
    item: Object,
  },
  setup(props) {
    const item = Vue.toRef(props,'item');
    const store = useWallStore();
    const datestr = (id) => {
      let ms =  id ? parseInt(decodeTime(id)) : 0;
      let date = new Date(ms);
      return dayjs(date).format('YYYY-MM-DD HH:mm');
    }
    const remove = (id) => {
      store.removeItem(id)
    }
    return {
      item,
      datestr,
      remove,
    }
  },
}

CB.styles.globed(/*css*/`
.cbv-wall-item {
    display: grid;
    grid-template: ". ." auto / 20% 80%;
    font-size: 18px;
    margin-top: .5em;
}
.cbv-wall-item--id {
    color: gray;
    font-size: 81%;
}
.cbv-wall-item--body {
}
.cbv-wall-item--deleter {
    cursor: pointer;
    color: darkred;
    font-weight: bold;
    padding-left: .5em;
}
`);
