'use strict';


/** Работа с localStorage (извлечение, запись, удаление, ...) */
export function LS(prefix) {
  return {
    get(name) {
      let item = localStorage.getItem(`${prefix}_${name}`);
      let result = JSON.parse(
        item == "undefined" ? "{}" : item
      );
      return result || void 0;
    },

    set(name, value) {
      localStorage.setItem(`${prefix}_${name}`, JSON.stringify(value));
    },

    has(name) {
      return !!localStorage.getItem(`${prefix}_${name}`);
    },

    delete(name) {
      localStorage.removeItem(`${prefix}_${name}`);
    }
  }
}
