/**
 * Экранирования спец.символов.
 * @param {String} text   Строка для экранирования спец.символов
 * @returns {String}      Экранированная строка
 */
function escapeHtml(text) {
  return text.replace(/[&<>"']/g, function(item) {
    return ({
      '&': '&amp;',
      '<': '&lt;',
      '>': '&gt;',
      '"': '&quot;',
      "'": '&#039;'
    })[item];
  });
}

/**
 * Сформировать время
 * @param {Date} dateString       Дата
 * @param {Boolean} displayTime   Сформировать строку даты с часами и минутами
 * @param {Boolean} displaySec    Сформировать строку даты еще и с секундами
 * @returns {string}              Строка даты в формате заданном в файле перевода конфигурации
 */
function formLocalTime(dateString = new Date(), displayTime = false, displaySec = false) {
  const date = moment(dateString);
  return displayTime ? (
    date.format((lang?.date_format_default || 'dd.mm.yyyy').toLocaleUpperCase() + ' HH:mm' + (
      displaySec ? ':ss' : ''
    ))
  ) : date.format((lang.date_format_default).toLocaleUpperCase());
}


function user_multi_select(el, type_field = '')
{
    var trigger_for_all = true;
    var values_to_post = [];
    var hidden_input_for_vals = $(el).parent().parent().find('input[data-js=\'checked_vals\']');
    var string_to_insert_in_hidden_input_for_vals = '';
    var els_for_add_check = $(el).parent().parent().find('input[data-js=\'value\']');
    /* кнопка 'все'*/
    var all_checkbox = $(el).parent().parent().find('input[data-js=\'all_vals\']');
    /* вычисления для кнопки "все" */
    if($(el).attr('data-js') === 'all_vals' && $(el).prop( "checked" )) {
        els_for_add_check.each(function( index ) {
           $( this ).prop("checked", true);
            values_to_post.push($(this).val());
        })
    } else if($(el).attr('data-js') === 'all_vals' && !$(el).prop( "checked" )) {
        els_for_add_check.each(function( index ) {
            $( this ).prop("checked", false);
        });
        values_to_post = [];
    } else { /* вычисления для простого чекбокса
            пройти по всем чекбоксам, если все чекнутые, включить кнопку все
            если хоть один не чекнутый, выключить кнопку */
        els_for_add_check.each(function( index ) {
            if($( this ).prop("checked") === false) {
                trigger_for_all = false;
            } else{
                values_to_post.push($(this).val());
            };
        });
        if (trigger_for_all) {
            all_checkbox.prop("checked", true);
        } else {
            all_checkbox.prop("checked", false);
        }
    }
    /* формируем строку для записи */
    for (var value in values_to_post) {
        if(type_field == 4){
            if(string_to_insert_in_hidden_input_for_vals === '') {
                string_to_insert_in_hidden_input_for_vals += values_to_post[value];
            } else {
                string_to_insert_in_hidden_input_for_vals += '\r\n' + values_to_post[value];
            }
        }else{
            if(string_to_insert_in_hidden_input_for_vals === '') {
                string_to_insert_in_hidden_input_for_vals += values_to_post[value];
            } else {
                string_to_insert_in_hidden_input_for_vals += '-' + values_to_post[value];
            }
        }
    }
    /* записываем данные в скрытый инпут */
    hidden_input_for_vals.val(string_to_insert_in_hidden_input_for_vals);
}



function set_on_image(a, ext, hash) {
  img_cats = document.getElementById('img_cat_' + a);
  img_cats.src = 'cache/img_cat_on_' + a + '.' + ext + '?hash=' + hash;
}

function set_image(a, ext, hash) {
  img_cats = document.getElementById('img_cat_' + a);
  img_cats.src = 'cache/img_cat_' + a + '.' + ext + '?hash=' + hash;
}


/**
 * Функция для декодирования HTML сущностей
 * @param {string} str       Строка с символами
 * @returns {string}         Строка с декодированные символами
 */
function decodeHtmlEntities(str) {
  var txt = document.createElement("textarea");
  txt.innerHTML = str;
  return txt.value;
}
