//Описываем структуру формы настроек в виде многоуровневого массива
const composition = [
  {
    //Вкладка "Таблицы"
    header: "connectors",

    forms: [
      {
        showOn: "apps",

        header: "prepare_tables",

        //listForm=true - форма со списком, управляет массивом настроек
        listForm: true,

        //field: поле, содержащее массив настроек
        field: "connectors",

        //addButton: текст ссылки добавления нового элемента
        addButton: "add_table",

        //listFields - поля, которые будут выведены в списке
        listFields: ["name"],
        
        activity:  {
            field: "disabled",
            on: 0,
            off: 1
        },
        
        copy: true,

        alert: {
          field: "__error"
        },           


        formBlocks: [
          {
            //Общие настройки таблицы
            fields: ["name", "instant" ,"internal_object_id"],
          },

          {
            //Настройки вызова команда
               header: 'connector_command_settings',       
               fields: ['external_action'],
               custom: {
                   'integration-fields-mapping': {
                       prefix: "external_action_params_",
                       fieldsList: "params",
                       fieldsType: true,
                       app_object: "external_object_type",
                       app_object_static: "gpt-request",
                       app_action: "external_action",
                       help: "help_clientbase_gpt",
                       help_unique: true
                   }
               }                                        
          },         

          {
            header: "fields_mapping",
            custom: {
              "integration-fields-mapping": {
                app_object: "external_object_type",
                app_object_static: "gpt-request",
                app_action: "external_action",
                table: "internal_object_id",
                help: "help_clientbase_gpt",
                help_unique: true
              },
            },
          },
          {
            fields: ['status_service_field']
          },

           {
            header: "knowledge_base",
            showOn: "external_action",
            showOnValue: "text_to_text",
            fields: ["external_action_params_knowledge_base_dropdown"],
          },

          {
            header: "conversations_header",
            showOn: "external_action",
            showOnValue: "text_to_text",
            formLines: [
              {
                label: "conversations",
                fields: ["external_action_params_conversations"],
                help: "help_clientbase_gpt_conv_enable"
              },
              {
                showOn: "external_action_params_conversations",
//                showOnValue: "1",
                label: "conversation_link",
                fields: ["fm_conversation_link"],
                help: "help_clientbase_gpt_conv_link"
              },
              {
                showOn: "external_action_params_conversations",
//                showOnValue: "1",
                label: "conversations_autodrop",
                fields: ["external_action_params_conversations_autodrop"],
                help: "help_clientbase_gpt_conv_autodrop"
              }
            ]
          }, 

          {
            showOn: "calc",
            fields: ["calc"]
          }
        ],
      }
    ],
  },

  //Вкладка "База знаний"
  {
    header: "knowledge_base_navbar",
     forms: [
      {
        showOn: "tariff_name",

        header: "knowledge_base",

        //listForm=true - форма со списком, управляет массивом настроек
        listForm: true,

        //field: поле, содержащее массив настроек
        field: "knowledge",

        //addButton: текст ссылки добавления нового элемента
        addButton: "add_knowledge",

        //listFields - поля, которые будут выведены в списке
        listFields: ["name"],
        
        activity:  {
            field: "disabled",
            on: 0,
            off: 1
        },
        
        copy: true,

        alert: {
          field: "status_upload"
        }, 
        formBlocks: [
          { 
            fields: ['name','knowledge_tables'] 
          },
          { 
            showOn: "status_upload",
            showOnValue: 'Таблицы готовы к отправке',
            fields: ['status_upload','file_size_kb', "embend_token", 'stor_token', 'date_update'] 
          },
          { 
            showOn: "status_vs",
            showOnValue: ["Идет обработка данных", "Обработка завершена"],
            fields: ['status_vs','file_size_kb', "embend_token", 'stor_token', 'date_update'] 
          },
          { 
            showOn: "show_knowledge_update",
            fields: ['knowledge_update'] 
          },
          { 
            showOn: "status_upload",
            showOnValue: 'Таблицы готовы к отправке',
            fields: ['knowledge_upload'], 
          },
          
        ]
      },
      {
        hideOn: "tariff_name",
        saveButton: false,
        formBlocks: [
          { 
              
              message: {
                template: "Функционал доступен при подключении опции Модуль Clientbase GPT",
                status: "alert"
              }
          }
        ]


      }
    ]
  },

  {
    //Вкладка "Информация"
    header: "information",

    forms: [
      {
        showOn: "apps",
        header: "prepare_information",
        saveButton: false,

        formBlocks: [
          {
            showOn: "__error",
            message: {
              template: "Ошибка: {{__error}}",
              status: "alert",
            }
          },
          {
            hideOn: "__error",
            fields: ["token_limit"],
          },
          {

            buttons: [
                            {
                                label: "Обновить информацию",
                                apiAction: "/api/dev/cbext/clientbase/clientbase_gpt/update_info",
                            }
                        ]
          },
        ],
      },
    ],
  },
];

export default composition;
