'use strict';

import { getLang } from "../lang.js";

export const initFunctions = async (_store, cbext_path) => {
    let store = _store;
    let l = getLang(config["lang"] == "russian" ? config["lang"] : "english");

    async function getData(url){
        let response = await fetch(url, {
            credentials: 'include',
            headers: {
                'X-Auth-Token': window.x_auth_token,
            },
        });
        let data = await response.json();

        return data;
    }


    let settings_data = await getData('./api/dev/settings/cbext.clientbase.iptel_primatel');
    let account_data = settings_data.data.attributes.value.personal_account_details;

    let user_settings = settings_data.data.attributes.value.users.filter(item => item.cb_user == user.id)[0];

    if(user_settings == void 0){
        store.set('user_status', {
            status: false,
            message: l["user_not_added_to_telephony"]
        });
        return;
    }

    let cb_users_data = await getData('./api/dev/users');

    let users_info = [];
    for(let user_sip of settings_data.data.attributes.value.users){
        if(user_sip.cb_user == user.id) continue;

        for(let user_cb of cb_users_data.data){
            if(user_sip.cb_user == user_cb.id){
                users_info.push({
                    id: user_cb.id,
                    name: user_cb.attributes.fio,
                    short_number: user_sip.short_sip_number
                });
            }
        }
    }
    function clearInfo(is_hang_up = false, use_local_storage = true){
        store.delete('phone_number___dtmf');
        store.delete('phone_number___changer');
        if(!is_hang_up){
            store.set('is_showed_call_block', false, use_local_storage);
            store.set('phone_number', '', use_local_storage);
        }
        else if(!document.hidden){
            store.set('is_showed_call_block', true, use_local_storage);
        }
        store.set('service_text', '', use_local_storage);
        store.set('notification_text', '', use_local_storage);
        store.set('is_call', false, use_local_storage);
        store.set('call_type', '', use_local_storage);
        store.set('asterisk_time', '00:00:00', use_local_storage);
        callIndicator(true);
        store.set('timerId', clearInterval(store.get('timerId')), use_local_storage);
        store.get('go_time')(true);
        store.set('redirect_number', '', use_local_storage);
        store.set('show_redirect_block', false, use_local_storage);
        if(store.get('oldTitle') && (store.get('_ua') || store.get('session') ||store.get('iSession'))){
            document.title = store.get('oldTitle');
        }
        if(store.get('oldIcon') && (store.get('_ua') || store.get('session') ||store.get('iSession'))){
            document.querySelector("link[rel~='icon']").href = store.get('oldIcon');
        }
    }

    function callIndicator(clear = false){
        if(clear){
            store.set('timerId', clearInterval(store.get('timerId')));
            return;
        }
        store.set('oldTitle', document.title),
        store.set('oldIcon', document.querySelector("link[rel~='icon']").href);
        store.set('timerId', setInterval(function(){
            if(document.title != l["call___"]){
                document.title = l["call___"];
                document.querySelector("link[rel~='icon']").href = `./${cbext_path}/assets/images/tel.png`;
            }
            else {
                document.title = store.get('oldTitle');
                document.querySelector("link[rel~='icon']").href = store.get('oldIcon');
            }
        }, 1000));
    }

    function fillVariables(variables = []){
        for(let variable of variables){
            if(!store.has(variable.name)){
                store.set(variable.name, variable.default);
            }
        }
    }

    function showEndCallTime(time){
        store.set('show_call_notification', true);
        store.set('notification_title', l["the_call_is_over"]);
        store.set('notification_text', `${l["call_duration"]} ${time}`);
    }

    async function fillCardInfo(_phone_number){
        let response = await fetch('./api/dev/cbext/clientbase/iptel_primatel/find?number='+_phone_number, {
            method: 'GET',
            credentials: 'include',
            redirect: 'follow',
            headers: {
                'X-Auth-Token': window.x_auth_token,
                "Accept": "application/vnd.api+json",
                "Content-Type": "application/vnd.api+json"
            }
        });
        let msg = await response.json();
        if (msg) {
            store.set('show_call_notification', true);
            var from =`${msg['name']['field_name']}: `
            var from_name = msg['name']['value'];
            if (from_name == 'NULL_NAME') from_name = '';
            var from_url = msg['url'];
            if (msg['issetClientCard']) {
                var addit_1 = (Object.keys(msg['additional_fields'][0]).length > 0) ? `${msg['additional_fields'][0]['field_name']}: ${msg['additional_fields'][0]['value']}` : '',
                    addit_2 = (Object.keys(msg['additional_fields'][1]).length > 0) ? `${msg['additional_fields'][1]['field_name']}: ${msg['additional_fields'][1]['value']}` : '',
                    addit_3 = (Object.keys(msg['additional_fields'][2]).length > 0) ? `${msg['additional_fields'][2]['field_name']}: ${msg['additional_fields'][2]['value']}` : '';
            }

            store.set('notification_info', {
                from_number: _phone_number,
                from,
                from_name,
                from_url,
                addit_1,
                addit_2,
                addit_3
            });

        }
    }

    async function requestForCreateTip(_phone_number){
        await fetch('./api/dev/cbext/clientbase/iptel_primatel/createAnsweredTip?user_id='+user.id+'&number='+_phone_number, {
            method: 'GET',
            credentials: 'include',
            redirect: 'follow',
            headers: {
                'X-Auth-Token': window.x_auth_token,
                "Accept": "application/vnd.api+json",
                "Content-Type": "application/vnd.api+json"
            }
        });
    }

    function incomingCallHandler(type = '', _phone_number = ''){
        if(type == 'accepted'){
            store.get('stopSound')();
            store.get('playSound')("answered.mp3", false);
            let Call = store.get('Call');
            Call['incoming']['incomingNumberGo'] = true;
            store.set('Call', Call);
            store.set('is_call', true);
            store.get('go_time')();
            store.set('phone_number___changer', () => {
                if(store.get('phone_number').match('#') == null){
                    let phone_number = store.get('phone_number').slice(0, -1) + '#' + store.get('phone_number').slice(-1);
                    store.set('phone_number', phone_number);
                }
            });
            store.set('phone_number___dtmf', () => {
                if(store.get('phone_number').match('#') != null && store.get('phone_number').split('#')[1]){
                    store.get('session').sendDTMF(store.get('phone_number').split('#')[1].slice(-1));
                }
            });
        }
        else if(type == 'confirmed'){

        }
        else if(type == 'failed'){
            store.get('stopSound')();
            let Call = store.get('Call');
            Call.isCall = false;
            Call['incoming'] = {};
            store.set('Call', Call);
            clearInfo(true);
            store.get('closeNotification')();
        }
        else if(type == 'ended'){
            store.get('stopSound')();
            let Call = store.get('Call');
            Call.isCall = false;
            Call['incoming'] = {};
            store.set('Call', Call);
            let time = store.get('asterisk_time');
            requestForCreateTip(store.get('phone_number'));
            clearInfo(true);
            showEndCallTime(time);
        }
        else {
            store.get('stopSound')();
            store.get('playSound')("ringing.ogg", true);
            let Call = store.get('Call') || {};
            Call['isCall'] = true;
            Call['incoming'] = {};
            Call['incoming']['incomingNumber'] = _phone_number;
            store.set('Call', Call);
            /* Именение тайтла и иконки с периодичностью при звонке */
            callIndicator();
            store.set('call_type', 'incoming');
            store.set('notification_title', l["incoming_call"]);
            store.set('phone_number', _phone_number);
            /* --- */
            store.set('is_showed_call_block', true);
            store.set('show_call_notification', true);
        }
    }

    function outgoingCallHandler(type = '', data = {}){
        if(type == 'progress'){
            store.set('call_status', 'progress');
            store.set('service_text', l["progress___"]);
            store.get('playSound')("ringback.ogg", true);
        }
        else if(type == 'accepted'){
            store.set('call_status', 'accepted');
            store.set('service_text', 'Accepted.');

            store.set('show_number_block', true);

            store.get('stopSound')();
            store.get('playSound')("answered.mp3", false);

            store.get('go_time')();

            store.set('phone_number___changer', () => {
                if(store.get('phone_number').match('#') == null){
                    let phone_number = store.get('phone_number').slice(0, -1) + '#' + store.get('phone_number').slice(-1);
                    store.set('phone_number', phone_number);
                }
            });
            store.set('phone_number___dtmf', () => {
                if(store.get('phone_number').match('#') != null && store.get('phone_number').split('#')[1].length > 0){
                    store.get('session').sendDTMF(store.get('phone_number').split('#')[1].slice(-1));
                }
            });
        }
        else if(type == 'failed'){
            JsSIP.Utils.closeMediaStream(store.get('_localClonedStream'));

            store.set('call_status', 'failed');
            store.set('service_text', data.cause);

            store.get('stopSound')();
            store.get('playSound')("rejected.mp3", false);

            let Call = store.get('Call');
            Call.isCall = false;
            Call['outgoing'] = {};
            store.set('Call', Call);

            clearInfo(true);
            store.get('closeNotification')();

            if(data.phone_numbers.length != 0){
                store.get('call')(data.phone_numbers);
                return;
            }
        }
        else if(type == 'ended'){
            JsSIP.Utils.closeMediaStream(store.get('_localClonedStream'));

            store.set('call_status', 'ended');
            store.set('service_text', l["ended"]);

            store.get('stopSound')();
            store.get('playSound')("rejected.mp3", false);

            let Call = store.get('Call');
            Call.isCall = false;
            Call['outgoing'] = {};
            store.set('Call', Call);

            let time = store.get('asterisk_time');
            requestForCreateTip(store.get('phone_number'));
            clearInfo(true);
            showEndCallTime(time);
            //this.session.terminate();
            if(data.phone_numbers.length != 0){
                store.get('call')(data.phone_numbers);
                return;
            }
        }
        else {
            store.set('is_call', true);
            // Делаем ИСХОДЯЩИЙ звонок

            let Call = store.get('Call') || {};
            Call['isCall'] = true;
            Call['outgoing'] = {};
            Call['outgoing']['number'] = data.number;
            store.set('Call', Call);

            callIndicator();

            store.set('notification_title', l["outgoing_call"]);
            store.set('call_type', 'outgoing');
            store.set('show_call_notification', true);
        }
    }

    fillVariables([
        {
            name: 'can_login',
            default: true,
        },
        {
            name: 'service_text',
            default: '',
        },
        {
            name: 'phone_number',
            default: '',
        },
        {
            name: 'asterisk_time',
            default: '00:00:00',
        },
        {
            name: 'tone',
            default: '2',
        },
        {
            name: 'options',
            default: {
                pcConfig: {
                    hackStripTcp: true, // Важно для хрома, чтоб он не тупил при звонке
                    rtcpMuxPolicy: 'negotiate', // Важно для хрома, чтоб работал multiplexing. Эту штуку обязательно нужно включить на астере.
                    iceServers: [{
                        urls:['stun:stun.l.google.com:19302']
                    }],
                    iceTransportPolicy: "all"
                },
                mediaConstraints: {
                    audio: true, // Поддерживаем только аудио
                    video: false
                },
                rtcOfferConstraints: {
                    offerToReceiveAudio: 1, // Принимаем только аудио
                    offerToReceiveVideo: 0
                }
            },
        },
        {
            name: 'is_call',
            default: false,
        },
        {
            name: 'callInterval',
            default: undefined,
        },
        {
            name: 'show_call_notification',
            default: false,
        },
        {
            name: 'call_type',
            default: '',
        },
        {
            name: 'notification_info',
            default: {},
        },
    ]);
    store.set('user_status', {
        status: true,
        message: ''
    });
    store.set('users_info', users_info);
    store.set('is_showed_call_block', false);
    store.set('provaiders' , {
        'Primatel':{
                'server': `${account_data.server}:${account_data.port}`,
                'domain': account_data.domain,
                'login': account_data.SIPnumber,
                'password': account_data.SIPpassword
        },
    });
    store.set('currentProvaider', 'Primatel');
    store.set('show_number_block', false);
    store.set('timerId', undefined);
    store.set('iSession', undefined);
    store.set('localStream', undefined);
    store.set('params', {
        url: 'https://api.primatel.ru', // адрес API
        rlogin: account_data.loginPBX,       // логин для доступа к API
        rkey: account_data.rkey,         // секретный ключ для формирования подписи к запросам
        login: account_data.loginPBX,        // логин личного кабинета
        password: account_data.passwordPBX,     // пароль личного кабинета
        sip_login: user_settings.sip_number,    // логин для авторизации SIP-телефона
        sip_password: user_settings.sip_password, // пароль для авторизации SIP-телефона
    });
    store.set('req', {
        login: store.get('params')['login'],
        password: store.get('params')['password'],
        sip_login: store.get('params')['sip_login'],
        sip_password: store.get('params')['sip_password']
    });
    store.set('calcSignature', function (data, rkey){
        keys = [];

        for (i in data)
        if (i != 'svc'
            && i != 'lang'
            && i != 'mode'
            && i != 'charset'
            && i != 'sid'
            && i != 'uqk'
            && i != 'rsign'
                )
            keys.push(i);

        keys.sort();

        var s = '';

        for (i in keys) {

        var key = keys[i];
        var val = data[key];

        if (typeof val  === 'object')
            val = '[' + arrayToStrForSign ( val ) + ']';

        s = s + val + ';';
        }

        s = s + rkey;

        let sign = CryptoJS.MD5(s).toString(CryptoJS.enc.Hex);

        return sign;
    });

    store.set('getYMDHMS', function (d) {
        function zeroFill (number, width)
        {
            var input = number + "";  // make sure it's a string
            var zeroFillData = "0000000000";
            return(zeroFillData.slice(0, width - input.length) + input);
        }

        var dd = zeroFill(d.getDate(), 2);
        var mm = zeroFill(d.getMonth() + 1, 2); //Months are zero based
        var yyyy = d.getFullYear();

        var HH = zeroFill(d.getHours(), 2);
        var MM = zeroFill(d.getMinutes(), 2); //Months are zero based
        var SS = zeroFill(d.getSeconds(), 2);

        return yyyy + '-' + mm + '-' + dd + ' ' + HH + ':' + MM + ':' + SS;
    });

    store.set('callRequest', async function (params, command, data = null, mode = 'json'){
        // Сформировать URL
        var url = params['url']
            + '?svc=' + command
            + '&mode=' + mode // не обязательный, по умолчанию будет 'xml'
            + '&lang=ru';      // не обязательный, по умолчанию будет 'en'

        var req = {
            method : 'POST',
            body: JSON.stringify(data, null, 4),
            credentials: 'same-origin', // enable cookies
        };

        let response = await fetch(url, req);

        var contentTypeRaw = response.headers.get("content-type");

        var A = contentTypeRaw.split(/;/);

        var contentType = A ? A[0] : contentTypeRaw;

        switch (contentType) {
            case 'application/json':
                let json = await response.json();
                if (response.ok) {
                    return json;
                } else {
                    throw new Error('[' + command + '] Call failed. HTTP status ' + response.status + ' ' + response.statusText);
                }
            case 'audio/mpeg':
                let blob = await response.blob();
                if (response.ok) {
                    return window.URL.createObjectURL(blob);
                } else {
                    throw new Error('[' + command + '] Call failed. HTTP status ' + response.status + ' ' + response.statusText);
                }
            default:
                return undefined;
        }
    });

    // Выполнить подписанный запрос
    store.set('scall', async function (params, command, data = null, mode = 'json'){
        var keys = [];

        if (!data)
            data = {};

        data['rlogin'] = params['rlogin'];
        data['rsign'] = store.get('calcSignature')(data, params['rkey']);

        let result = await store.get('callRequest')(params, command, data, mode);

        return result;
    });

    store.set('showCallBlock', function (){
        let is_showed_call_block = store.get('is_showed_call_block');
        store.set('is_showed_call_block', !is_showed_call_block);
        if(!store.get('is_showed_call_block') && (store.get('Call') && !(!!store.get('Call').isCall))){
            //store.set('phone_number', '');
            store.set('service_text', '');
        }
        if (store.get('phone_number') != '') {
            let Call = store.get('Call') || {};
            Call['numberForCall'] = store.get('phone_number');
            store.set('Call', Call);
        }
        if(!is_showed_call_block){
            document.getElementById('call_block-tel_number').focus();
        }
    });

    store.set('loadPage', function () {
    });

    store.set('login', function (){
        if(!store.get('can_login') || trim(store.get('params')['sip_login']) == '' || trim(store.get('params')['sip_password']) == ''){
            return;
        }
        store.set('socket', new JsSIP.WebSocketInterface(store.get('provaiders')[store.get('currentProvaider')]['server']));
        store.set('_ua', new JsSIP.UA(
            {
                uri: "sip:" + store.get('params')['sip_login'] + "@" + store.get('provaiders')[store.get('currentProvaider')]['domain'],
                password: store.get('params')['sip_password'],
                display_name: store.get('loginText'),
                sockets: [store.get('socket')],
                session_timers: false
            }));

        // соединяемся с астером
        store.get('_ua').on('connecting', () => {
        });

        // соединились с астером
        store.get('_ua').on('connected', () => {
        });

        // астер нас зарегал, теперь можно звонить и принимать звонки
        store.get('_ua').on('registered', () => {
            store.set('can_login', false);
            store.set('showed_call_buttons', true);
        });

        // астер про нас больше не знает
        store.get('_ua').on('unregistered', () => {
        });

        // астер не зарегал нас, что то не то, скорее всего неверный логин или пароль
        store.get('_ua').on('registrationFailed', (data) => {
            console.error("UA registrationFailed", data.cause);
        });

        // заводим шарманку
        store.get('_ua').start();

        store.get('incomingCall')(store.get('_ua'));
    })

    store.set('logout', function () {
        // закрываем всё, вылогиниваемся из астера, закрываем коннект
        store.get('_ua').unregister();
        store.delete('iSession');
        store.delete('session');
        store.set('can_login', true);
    });

    store.set('incomingCall', function (ua) {
        ua.on('newRTCSession', async function(data){
            if(store.get('Call') && store.get('Call').isCall){
                return;
            }
            clearInfo(true);
            store.set('iSession', data.session);
            if (store.get('iSession').direction === "incoming") {
                incomingCallHandler('', data.request.from._display_name);
                try {
                    //await fillCardInfo(data.request.from._display_name);
                    let phone = data.request.from._display_name || data.request.from._uri._user;
                    await fillCardInfo(phone); // заполняем карточку клиента
                }
                catch (error) {
                    console.error(error);
                }
                store.get('iSession').on('peerconnection', function(data) {
                    data.peerconnection.addEventListener('addstream', function (e) {
                        // set remote audio stream
                        let remoteAudioControl = document.getElementById("remoteAudio");
                        remoteAudioControl.srcObject = e.stream;
                        remoteAudioControl.play();
                    });
                });

                // Звонок принят, можно начинать говорить
                store.get('iSession').on('accepted', () => {
                    incomingCallHandler('accepted');
                });

                store.get('iSession').on("confirmed",function(data){
                    incomingCallHandler('confirmed');
                });

                store.get('iSession').on("ended",function(data){
                    incomingCallHandler('ended');
                });
                store.get('iSession').on("failed",function(data){
                    incomingCallHandler('failed');
                });
            }
        });
    });

    store.set('incomingHangUp', function () {
        if (store.get('iSession')){
            store.get('playSound')("rejected.mp3", false);
            store.get('iSession').terminate();
        } else {
            let Call = store.get('Call');
            Call.isCall = false;
            Call['incoming'] = {};
            Call['incoming']['dropIncomingCall'] = true;
            store.set('Call', Call);

            Call['incoming'] = {};
            store.set('Call', Call);

            store.get('login')();
        }
    });

    store.set('call', async (_phone_numbers = []) => {
        clearInfo(true);
        store.get('closeNotification')();

        let phone_numbers = _phone_numbers;
        if(phone_numbers.length != 0){
            store.set('phone_number', trim(phone_numbers.shift()));
        }

        let number = store.get('phone_number');
        if(trim(number).length == 0){
            store.set('service_text', 'Number is empty!');
            setTimeout(() => {
                store.set('service_text', '');
            }, 5000);
            return;
        }
        if(number.length >= 10 && number[0] == '+' && number[1] == '7'){
            number = '8' + number.slice(2);
        }

        try {
            await fillCardInfo(number);
        }
        catch (error) {
            console.error(error);
        }

        store.set('session', store.get('_ua').call(number, store.get('options')));

        outgoingCallHandler('', {
            number
        });
        /* --- */
        // Астер нас соединил с абонентом
        store.get('session').on('connecting', () => {
            store.set('service_text', 'Connecting...');
            //playSound("ringback.ogg", true);
            // Тут мы подключаемся к микрофону и цепляем к нему поток, который пойдёт в астер
            let peerconnection = store.get('session').connection;
            store.set('localStream', peerconnection.getLocalStreams()[0]);
            if (store.get('localStream')) {
                let localStream = store.get('localStream');
                store.set('_localClonedStream', localStream.clone());


                let localAudioControl = document.getElementById("localAudio");
                localAudioControl.srcObject = store.get('_localClonedStream');
            }

            // Как только астер отдаст нам поток абонента, мы его засунем к себе в наушники
            peerconnection.addEventListener('addstream', (event) => {

                let remoteAudioControl = document.getElementById("remoteAudio");
                remoteAudioControl.srcObject = event.stream;
                remoteAudioControl.play();
            });
        });


        // В процессе дозвона
        store.get('session').on('progress', () => {

            outgoingCallHandler('progress');
        });

        // Дозвон завершился неудачно, например, абонент сбросил звонок
        store.get('session').on('failed', (data) => {

            outgoingCallHandler('failed', {
                cause: data.cause,
                phone_numbers
            });
        });

        // Поговорили, разбежались
        store.get('session').on('ended', (data) => {

            outgoingCallHandler('ended', {
                phone_numbers
            });
        });
        // Звонок принят, моно начинать говорить
        store.get('session').on('accepted', () => {

            outgoingCallHandler('accepted');
        });
    });

    store.set('hangUp', function(is_block_hang_up = false) {
        if (store.get('session')) {
            store.set('is_call', false);

            let Call = {
                isCall: false,
                outgoing: {},
            };
            store.set('Call', Call);

            store.get('session').terminate();
        } else {
            store.set('is_call', false);
            let Call = {
                isCall: false,
                outgoing: {
                    dropCall: true
                }
            };
            store.set('Call', Call);

            Call['outgoing'] = {};
            store.set('Call', Call);

            clearInfo(true, false);

            store.get('login')();
        }
    });

    store.set('playSound', function(soundName, loop) {
        let sound_element = document.getElementById('sounds');
        sound_element.src = `./${cbext_path}/assets/sounds/` + soundName;
        sound_element.loop = loop;
        sound_element.muted = true;
        sound_element.play();
        sound_element.muted = false;
    });

    store.set('stopSound', function() {
        let sound_element = document.getElementById('sounds');
        sound_element.pause();
        sound_element.currentTime = 0.0;
    });

    store.set('go_time', function (clear = false) {
        var prev_sec = 0,
            sec_,
            min_,
            hours_,
            zeros,
            zerom,
            pos;
        if (clear) {
            if (store.get('callInterval')) {
                setTimeout(function () {
                    store.set('callInterval', clearInterval(store.get('callInterval')));
                }, 0);
            } else {
                return false;
            }
        } else {
            store.set('callInterval', setInterval(function () {
                sec_ = prev_sec % 60;
                min_ = intval(prev_sec / 60);
                hours_ = '00';

                zeros = '';
                if (sec_ < 10) zeros = '0';
                zerom = '';
                if (min_ < 10) zerom = '0';

                store.set('asterisk_time', hours_ + ':' + zerom + min_ + ':' + zeros + sec_);

                prev_sec++;
            }, 1000));
        }
    })

    store.set('callAnswer', function() {
        store.get('iSession').answer(store.get('options'));
        store.set('is_call', true);
    });

    store.set('closeTipTimeout', function () {
        store.set('show_call_notification', false);
    });

    store.set('startForwardCall', function (){
        store.set('show_redirect_block', true);
        if(
            store.get('iSession') &&
            Object.keys(store.get('iSession')).length > 0
        ){
            store.get('iSession').hold();

        }
    });

    store.set('forwardCall', function (){
        store.get('iSession').refer(store.get('redirect_number'));
        store.get('incomingHangUp')();
    });

    store.set('closeNotification', function (){
        store.set('show_call_notification', false);
        store.set('notification_title', '');
        store.set('notification_text', '');
        store.set('notification_info', {});
    });

    window.addEventListener('storage', function(event) {
        if (event.key == 'Call') {
            let callEvent = JSON.parse(event.newValue).data;
            if (callEvent.provaider) {
                store.set('currentProvaider', callEvent.provaider, true);
            }
            if (callEvent.numberForCall) {
                store.set('phone_number', callEvent.numberForCall, true);
            }
            if (callEvent.outgoing) {
                if (callEvent.outgoing.dropCall) {
                    if (store.get('session')){
                        JsSIP.Utils.closeMediaStream(store.get('_localClonedStream'));
                        store.get('session').terminate();

                        let new_call = callEvent;
                        new_call.outgoing = {};
                        store.set('Call', new_call, true);

                        store.get('logout')();
                    }
                    clearInfo(true, false);
                }
                else {
                    store.set('Call', callEvent, false);
                }
                if (callEvent['outgoing'].number) {
                    store.set('phone_number', callEvent['outgoing'].number, false);
                }
            } else if (callEvent.incoming) {
                if (callEvent['incoming'].incomingNumber && !callEvent['incoming'].incomingNumberGo) {
                    store.set('Call', callEvent, false);
                }
                if (callEvent.incoming.dropIncomingCall) {
                    if (store.get('iSession') && Object.keys(store.get('iSession')).length > 0){
                        // Reject call (or hang up it)
                        store.get('playSound')("rejected.mp3", false);
                        callIndicator(true);
                        let Call = {
                            isCall: false,
                            incoming: {},
                        };
                        store.set('Call', Call);
                        // Reject call (or hang up it)
                        store.get('iSession').terminate();
                        clearInfo(true, false);
                        store.get('logout')();
                    }
                }
                else {
                    store.set('Call', callEvent, false);
                }
            }
            if(
                !callEvent.isCall &&
                (callEvent.incoming && Object.keys(callEvent.incoming).length == 0 ||
                callEvent.outgoing && Object.keys(callEvent.outgoing).length == 0)
            ){
                clearInfo(false, false);
            }
        }
        if(
            event.key == 'is_showed_call_block' &&
            !store.has('iSession') &&
            !store.has('session')
        ){
            store.set('is_showed_call_block', false, false);
        }
        if(event.key == 'can_login' && event.newValue == 'true'){
            if (store.has('iSession') &&
                store.has('session')) {
                    store.get('logout')();
                }
        }
        if (
            event.key == 'asterisk_time' ||
            event.key == 'show_call_notification' ||
            event.key == 'notification_info' ||
            event.key == 'notification_text' ||
            event.key == 'notification_title' ||
            event.key == 'phone_number' ||
            event.key == 'service_text' ||
            event.key == 'is_call' ||
            event.key == 'call_type' ||
            event.key == 'call_status'
        ) {
            store.set(event.key, JSON.parse(event.newValue).data, false);
        }
    });

    document.addEventListener("visibilitychange", function(){
        if (!store.get('Call') || !store.get('Call').isCall) {
            if (document.hidden) {
                //store.get('logout')();
            } else {
                if(!store.has('iSession') &&
                    !store.has('session')){
                    store.set('can_login', true);
                    store.get('login')();
                }
            }
        }
    });

    $(document).ready(function(){
        store.get('loadPage')();
        store.get('login')();
    });


    window.addEventListener('beforeunload', (event) => {
        if(store.get('session')){
            store.get('session').terminate();
        }
    });
}
