//Описываем структуру формы настроек в виде многоуровневого массива
const composition = [

    {
        //Вкладка "Таблицы"
        header: 'tables',

        forms: [

            {

                header: "prepare_tables",
                
                //listForm=true - форма со списком, управляет массивом настроек
                listForm: true,

                //field: поле, содержащее массив настроек
                field: "tables",

                //addButton: текст ссылки добавления нового элемента
                addButton: "add_table",

                //listFields - поля, которые будут выведены в списке
                listFields: ['name'],


                formBlocks: [
                    { //Общие настройки таблицы

                        formLines: [
                            {
                                label: 'name',
                                fields: ['name']
                            },     
                            {
                                label: 'internal_object_id',
                                fields: ['internal_object_id']
                            },                                 
                            {
                                label: 'auth_allforms',
                                fields: ['auth_allforms']
                            },
                            {
                                showOn: 'auth_allforms',
                                showOnValue: 'no',
                                label: 'auth_form_id',
                                fields: ['auth_form_id']
                            },
                            {
                                label: 'internal_connect_field',
                                fields: ['internal_connect_field']
                            },                               
                        ],                                        
                    },
                    {
                        header: 'fields_mapping',
                        custom: {
                            'integration-fields-mapping': {
                                app_object: "external_object_type",
                                app_object_static: "orders",
                                table: "internal_object_id",
                                help: "help_tilda",
                                help_unique: true
                            }
                        }
                    }
                ],

                archive: {
                    field: "arc",
                    on: "1",
                    off: "0"
                }                

            },  

        ]        

    },    

    {
        //Вкладка "Дополнительно"
        header: 'setwebhook',

        forms: [
            {
                header: 'setwebhook',
                //saveButton: false,
                fields: ['webhook', 'webhook_enabled', 'disable_forms', 'webhook_refresh'],
            }
        ]
    }


];

export default composition;